/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.parsers;

import io.jenkins.plugins.pipeline.exceptions.PipelineAsYamlException;
import io.jenkins.plugins.pipeline.exceptions.PipelineAsYamlUnknownTypeException;
import io.jenkins.plugins.pipeline.interfaces.ParserInterface;
import io.jenkins.plugins.pipeline.models.ParallelModel;
import io.jenkins.plugins.pipeline.models.StageModel;
import io.jenkins.plugins.pipeline.parsers.AbstractParser;
import io.jenkins.plugins.pipeline.parsers.StageParser;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;

public class ParallelParser
extends AbstractParser
implements ParserInterface<ParallelModel> {
    private LinkedHashMap parentNode;

    public ParallelParser(LinkedHashMap parentNode) {
        this.yamlNodeName = "parallel";
        this.parentNode = parentNode;
    }

    @Override
    public Optional<ParallelModel> parse() {
        try {
            ArrayList<StageModel> stageModelList = new ArrayList<StageModel>();
            Object parallelObject = this.getChildNodeAsObject(this.parentNode);
            if (parallelObject instanceof List) {
                for (LinkedHashMap childStage : (List)parallelObject) {
                    Optional<StageModel> stageModel = new StageParser(childStage).parse();
                    stageModel.ifPresent(stageModelList::add);
                }
                return Optional.of(new ParallelModel(stageModelList));
            }
            throw new PipelineAsYamlUnknownTypeException(parallelObject.getClass().toString());
        }
        catch (PipelineAsYamlException p) {
            return Optional.empty();
        }
    }
}

