/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.parsers;

import io.jenkins.plugins.pipeline.exceptions.PipelineAsYamlException;
import io.jenkins.plugins.pipeline.interfaces.ParserInterface;
import io.jenkins.plugins.pipeline.models.AgentModel;
import io.jenkins.plugins.pipeline.models.KeyValueModel;
import io.jenkins.plugins.pipeline.parsers.AbstractParser;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Optional;

public class AgentParser
extends AbstractParser
implements ParserInterface<AgentModel> {
    private LinkedHashMap agentNode;
    private LinkedHashMap parentNode;

    public AgentParser(LinkedHashMap parentNode) {
        this.yamlNodeName = "agent";
        this.parentNode = parentNode;
    }

    @Override
    public Optional<AgentModel> parse() {
        try {
            Object tempNode = this.getChildNodeAsObject(this.parentNode);
            if (tempNode instanceof String) {
                return Optional.of(new AgentModel((String)tempNode, new ArrayList<KeyValueModel>()));
            }
            this.agentNode = (LinkedHashMap)tempNode;
            String agentType = this.getKey(this.agentNode);
            return Optional.of(new AgentModel(agentType, this.extractParameters(this.agentNode.get(agentType))));
        }
        catch (PipelineAsYamlException p) {
            return Optional.empty();
        }
    }
}

