/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.models;

import io.jenkins.plugins.pipeline.interfaces.ParsableModelInterface;
import io.jenkins.plugins.pipeline.models.AbstractModel;
import io.jenkins.plugins.pipeline.models.ScriptModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class StepsModel
extends AbstractModel
implements ParsableModelInterface {
    public static final String directive = "steps";
    private List<String> steps = new ArrayList<String>();
    private Optional<ScriptModel> script = Optional.empty();

    public StepsModel(List<String> steps) {
        this.steps = steps;
    }

    public StepsModel(Optional<ScriptModel> script) {
        this.script = script;
    }

    public StepsModel(String steps) {
        this.steps = Arrays.asList(steps.split("\n"));
    }

    @Override
    public String toGroovy() {
        StringBuffer groovyString = new StringBuffer();
        groovyString.append(directive).append(this.getDirectiveOpen());
        this.steps.stream().forEach(step -> groovyString.append((String)step).append("\n"));
        groovyString.append(this.script.map(ScriptModel::toGroovy).orElse("")).append(this.getDirectiveClose());
        return groovyString.toString();
    }

    public String toGroovyForPostModel() {
        StringBuffer groovyString = new StringBuffer();
        this.steps.stream().forEach(step -> groovyString.append((String)step).append("\n"));
        return groovyString.toString();
    }

    @Generated
    public List<String> getSteps() {
        return this.steps;
    }

    @Generated
    public Optional<ScriptModel> getScript() {
        return this.script;
    }

    @Generated
    public void setSteps(List<String> steps) {
        this.steps = steps;
    }

    @Generated
    public void setScript(Optional<ScriptModel> script) {
        this.script = script;
    }
}

