/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.models;

import io.jenkins.plugins.pipeline.interfaces.ParsableModelInterface;
import io.jenkins.plugins.pipeline.models.AbstractModel;
import io.jenkins.plugins.pipeline.models.SubScriptModel;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class ScriptModel
extends AbstractModel
implements ParsableModelInterface {
    public static final String directive = "script";
    private List scripts;
    private Boolean printDirective = true;

    public ScriptModel(List scripts) {
        this.scripts = scripts;
    }

    public ScriptModel(String scripts) {
        this.scripts = Arrays.asList(scripts.split("\n"));
    }

    public void setPrintDirective(Boolean printDirective) {
        this.printDirective = printDirective;
    }

    @Override
    public String toGroovy() {
        StringBuffer groovyString = new StringBuffer();
        groovyString.append(this.printDirective != false ? directive : "").append(this.getDirectiveOpen());
        for (Object script : this.scripts) {
            if (script instanceof String) {
                groovyString.append(script).append("\n");
                continue;
            }
            Optional subScriptModel = (Optional)script;
            groovyString.append(subScriptModel.map(SubScriptModel::toGroovy).orElse(""));
        }
        groovyString.append(this.getDirectiveClose());
        return groovyString.toString();
    }

    @Generated
    public List getScripts() {
        return this.scripts;
    }

    @Generated
    public Boolean getPrintDirective() {
        return this.printDirective;
    }
}

