/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.cps;

import hudson.model.Action;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import io.jenkins.plugins.pipeline.exceptions.PipelineAsYamlRuntimeException;
import io.jenkins.plugins.pipeline.models.PipelineModel;
import io.jenkins.plugins.pipeline.parsers.PipelineParser;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;

public class PipelineCpsScmFlowDefinition
extends CpsScmFlowDefinition {
    public PipelineCpsScmFlowDefinition(SCM scm, String scriptPath, boolean lightweight) {
        super(scm, scriptPath);
        this.setLightweight(lightweight);
    }

    public PipelineCpsScmFlowDefinition(SCM scm, String scriptPath) {
        super(scm, scriptPath);
    }

    public CpsFlowExecution create(FlowExecutionOwner owner, TaskListener listener, List<? extends Action> actions) throws Exception {
        CpsFlowExecution cpsFlowExecution = super.create(owner, listener, actions);
        String yamlJenkinsFileContent = cpsFlowExecution.getScript();
        if (StringUtils.isBlank((String)yamlJenkinsFileContent)) {
            throw new PipelineAsYamlRuntimeException("Jenkinsfile YAML cannot be blank");
        }
        PipelineParser pipelineParser = new PipelineParser(yamlJenkinsFileContent);
        Optional<PipelineModel> pipelineModel = pipelineParser.parse();
        if (!pipelineModel.isPresent()) {
            throw new PipelineAsYamlRuntimeException("PipelineModel is not present");
        }
        String jenkinsFileContent = pipelineModel.get().toPrettyGroovy();
        return new CpsFlowDefinition(jenkinsFileContent, cpsFlowExecution.isSandbox()).create(owner, listener, actions);
    }
}

