// CHECKSTYLE:OFF

package io.jenkins.plugins.pipeline;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code Project.ScriptFlowDefinitionDisplayName}: {@code Pipeline
     * As Yaml}.
     * 
     * @return
     *     {@code Pipeline As Yaml}
     */
    public static String Project_ScriptFlowDefinitionDisplayName() {
        return holder.format("Project.ScriptFlowDefinitionDisplayName");
    }

    /**
     * Key {@code Project.ScriptFlowDefinitionDisplayName}: {@code Pipeline
     * As Yaml}.
     * 
     * @return
     *     {@code Pipeline As Yaml}
     */
    public static Localizable _Project_ScriptFlowDefinitionDisplayName() {
        return new Localizable(holder, "Project.ScriptFlowDefinitionDisplayName");
    }

    /**
     * Key {@code ProjectRecognizer.DisplayName}: {@code by Jenkinsfile As
     * Yaml}.
     * 
     * @return
     *     {@code by Jenkinsfile As Yaml}
     */
    public static String ProjectRecognizer_DisplayName() {
        return holder.format("ProjectRecognizer.DisplayName");
    }

    /**
     * Key {@code ProjectRecognizer.DisplayName}: {@code by Jenkinsfile As
     * Yaml}.
     * 
     * @return
     *     {@code by Jenkinsfile As Yaml}
     */
    public static Localizable _ProjectRecognizer_DisplayName() {
        return new Localizable(holder, "ProjectRecognizer.DisplayName");
    }

    /**
     * Key {@code Project.SnippetizerDisplayName}: {@code Pipeline As YAML
     * Converter}.
     * 
     * @return
     *     {@code Pipeline As YAML Converter}
     */
    public static String Project_SnippetizerDisplayName() {
        return holder.format("Project.SnippetizerDisplayName");
    }

    /**
     * Key {@code Project.SnippetizerDisplayName}: {@code Pipeline As YAML
     * Converter}.
     * 
     * @return
     *     {@code Pipeline As YAML Converter}
     */
    public static Localizable _Project_SnippetizerDisplayName() {
        return new Localizable(holder, "Project.SnippetizerDisplayName");
    }

    /**
     * Key {@code Project.ScmFlowDefinitionDisplayName}: {@code Pipeline As
     * Yaml from SCM}.
     * 
     * @return
     *     {@code Pipeline As Yaml from SCM}
     */
    public static String Project_ScmFlowDefinitionDisplayName() {
        return holder.format("Project.ScmFlowDefinitionDisplayName");
    }

    /**
     * Key {@code Project.ScmFlowDefinitionDisplayName}: {@code Pipeline As
     * Yaml from SCM}.
     * 
     * @return
     *     {@code Pipeline As Yaml from SCM}
     */
    public static Localizable _Project_ScmFlowDefinitionDisplayName() {
        return new Localizable(holder, "Project.ScmFlowDefinitionDisplayName");
    }

}
