/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.agent_build_history;

import hudson.Util;
import hudson.model.Cause;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import io.jenkins.plugins.agent_build_history.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jenkins.console.ConsoleUrlProvider;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.actions.BodyInvocationAction;
import org.jenkinsci.plugins.workflow.actions.TimingAction;
import org.jenkinsci.plugins.workflow.cps.actions.ArgumentsActionImpl;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.DepthFirstScanner;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.support.actions.WorkspaceActionImpl;
import org.jenkinsci.plugins.workflow.support.steps.ExecutorStep;
import org.kohsuke.accmod.restrictions.suppressions.SuppressRestrictedWarnings;

public class WorkflowJobTrend {
    private static final double MAX_LIKELY_RUNS = 20.0;
    private static final int MAX_PER_PAGE = 40;
    private final List<WorkflowRunResult> results = new ArrayList<WorkflowRunResult>();
    private final List<WorkflowRun> runs;
    private final String statusFilter;
    private final String agentFilter;
    private final boolean filterByAgent;
    private int startNewer;
    private int startOlder;
    private int oldestBuild;
    private int newestBuild;
    private int startBuild;

    public WorkflowJobTrend(WorkflowJob job, String statusFilter, String agentFilter, String startBuildString) {
        this.statusFilter = statusFilter;
        this.agentFilter = agentFilter;
        this.filterByAgent = Util.fixEmptyAndTrim((String)agentFilter) != null;
        this.startBuild = Integer.parseInt(startBuildString);
        WorkflowRun lastRun = job.getLastBuild();
        if (lastRun != null) {
            WorkflowRun firstRun = job.getFirstBuild();
            this.runs = new ArrayList<WorkflowRun>();
            this.newestBuild = lastRun.getNumber();
            if (this.startBuild == -1) {
                this.startBuild = this.newestBuild;
            }
            if (this.startBuild < 40) {
                this.startBuild = 40;
            }
            if (this.startBuild > this.newestBuild) {
                this.startBuild = this.newestBuild;
            }
            int endBuild = this.startBuild;
            int i = 0;
            for (WorkflowRun n = job.getNearestBuild(this.startBuild); n != null && i < 40; n = n.getPreviousBuild()) {
                if (this.includeRun(n)) {
                    this.runs.add(n);
                    ++i;
                }
                endBuild = n.getNumber() - 1;
            }
            this.startOlder = endBuild;
            this.oldestBuild = 0;
            if (firstRun != null) {
                this.oldestBuild = firstRun.getNumber();
            }
            this.oldestBuild += 39;
            this.startNewer = this.startBuild + 40;
            if (this.startNewer > this.newestBuild) {
                this.startNewer = this.newestBuild;
            }
        } else {
            this.runs = Collections.emptyList();
            this.startOlder = -1;
            this.startNewer = Integer.MAX_VALUE;
            this.oldestBuild = -1;
            this.newestBuild = -1;
        }
    }

    public int getStartNewer() {
        return this.startNewer;
    }

    public int getStartOlder() {
        return this.startOlder;
    }

    public int getOldestBuild() {
        return this.oldestBuild;
    }

    public int getNewestBuild() {
        return this.newestBuild;
    }

    public int getStartBuild() {
        return this.startBuild;
    }

    public WorkflowJobTrend run() {
        return this;
    }

    private boolean includeRun(WorkflowRun run) {
        Result result = run.getResult();
        if (!"all".equals(this.statusFilter) && result != null) {
            if ("success".equals(this.statusFilter) && result != Result.SUCCESS) {
                return false;
            }
            if ("unstable".equals(this.statusFilter) && result != Result.UNSTABLE) {
                return false;
            }
            if ("failure".equals(this.statusFilter) && result != Result.FAILURE) {
                return false;
            }
            if ("aborted".equals(this.statusFilter) && result != Result.ABORTED) {
                return false;
            }
        }
        return true;
    }

    public List<WorkflowRunResult> getResults() throws Exception {
        for (WorkflowRun run : this.runs) {
            WorkflowRunResult result = this.calculate(run);
            if (result == null) continue;
            this.results.add(result);
        }
        return this.results;
    }

    @SuppressRestrictedWarnings(value={ArgumentsActionImpl.class, hudson.model.Messages.class})
    private WorkflowRunResult calculate(WorkflowRun run) {
        boolean include;
        WorkflowRunResult result = new WorkflowRunResult(run);
        FlowExecution flowExecution = run.getExecution();
        boolean bl = include = !this.filterByAgent;
        if (flowExecution != null) {
            for (FlowNode flowNode : new DepthFirstScanner().allNodes(flowExecution)) {
                StepStartNode startNode;
                StepDescriptor descriptor;
                if (!(flowNode instanceof StepStartNode) || !((descriptor = (startNode = (StepStartNode)flowNode).getDescriptor()) instanceof ExecutorStep.DescriptorImpl) || flowNode.getActions(BodyInvocationAction.class).isEmpty()) continue;
                for (FlowNode parent : flowNode.getParents()) {
                    String label;
                    WorkspaceActionImpl action;
                    StepStartNode parentNode;
                    StepDescriptor parentDescriptor;
                    if (!(parent instanceof StepStartNode) || !((parentDescriptor = (parentNode = (StepStartNode)parent).getDescriptor()) instanceof ExecutorStep.DescriptorImpl) || (action = (WorkspaceActionImpl)parentNode.getAction(WorkspaceActionImpl.class)) == null) continue;
                    NodeExecution nodeExecution = new NodeExecution();
                    String nodeName = action.getNode();
                    if (nodeName.isEmpty()) {
                        if (this.filterByAgent && this.agentFilter.equals("built-in")) {
                            include = true;
                        }
                        nodeExecution.builtOn = "(built-in)";
                        nodeExecution.builtOnStr = hudson.model.Messages.Hudson_Computer_DisplayName();
                    } else {
                        Node node = Jenkins.get().getNode(nodeName);
                        if (node != null) {
                            if (this.filterByAgent && this.agentFilter.equals(node.getNodeName())) {
                                include = true;
                            }
                            nodeExecution.builtOn = node.getNodeName();
                            nodeExecution.builtOnStr = node.getDisplayName();
                        } else {
                            if (this.filterByAgent && this.agentFilter.equals(nodeName)) {
                                include = true;
                            }
                            nodeExecution.builtOnStr = nodeName;
                        }
                    }
                    BlockEndNode endNode = startNode.getEndNode();
                    nodeExecution.duration = this.getDurationString((BlockStartNode)startNode, endNode);
                    ArgumentsActionImpl args = (ArgumentsActionImpl)parentNode.getAction(ArgumentsActionImpl.class);
                    if (args != null && (label = (String)args.getArgumentValue("label")) != null) {
                        nodeExecution.label = label;
                    }
                    result.addNodeExecution(nodeExecution);
                }
            }
        }
        if (include) {
            return result;
        }
        return null;
    }

    public String getDurationString(BlockStartNode startNode, BlockEndNode endNode) {
        TimingAction endTime;
        TimingAction startTime = (TimingAction)startNode.getAction(TimingAction.class);
        if (startTime == null) {
            return "n/a";
        }
        long endTimeLong = 0L;
        if (endNode != null && (endTime = (TimingAction)endNode.getAction(TimingAction.class)) != null) {
            endTimeLong = endTime.getStartTime();
        }
        if (endTimeLong == 0L) {
            return Messages.InProgressDuration(Util.getTimeSpanString((long)(System.currentTimeMillis() - startTime.getStartTime())));
        }
        return Util.getTimeSpanString((long)(endTimeLong - startTime.getStartTime()));
    }

    public static class WorkflowRunResult {
        private final WorkflowRun run;
        private List<NodeExecution> agents = new ArrayList<NodeExecution>();

        private WorkflowRunResult(WorkflowRun run) {
            this.run = run;
        }

        public void addNodeExecution(NodeExecution exec) {
            this.agents.add(exec);
        }

        public WorkflowRun getRun() {
            return this.run;
        }

        public List<NodeExecution> getAgents() {
            return this.agents;
        }

        public String getConsoleUrl() {
            return ConsoleUrlProvider.getRedirectUrl((Run)this.run);
        }

        public String getShortDescription() {
            List causeList = this.run.getCauses();
            if (!causeList.isEmpty()) {
                return ((Cause)causeList.get(causeList.size() - 1)).getShortDescription();
            }
            return "Unknown Cause";
        }
    }

    public static class NodeExecution {
        private String builtOn;
        private String builtOnStr;
        private String duration;
        private String label;

        public String getBuiltOn() {
            return this.builtOn;
        }

        public String getBuiltOnStr() {
            return this.builtOnStr;
        }

        public String getDuration() {
            return this.duration;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

