/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.agent_build_history;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Functions;
import hudson.model.BallColor;
import hudson.model.Cause;
import hudson.model.Run;
import io.jenkins.plugins.agent_build_history.AgentExecution;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jenkins.console.ConsoleUrlProvider;
import jenkins.util.ProgressiveRendering;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class RunListTable
extends ProgressiveRendering {
    String computerName;
    private static final double MAX_LIKELY_RUNS = 20.0;
    private Iterable<AgentExecution> runs;
    private final List<JSONObject> results = new ArrayList<JSONObject>();

    public RunListTable(String computerName) {
        this.computerName = computerName;
    }

    public void setRuns(Iterable<AgentExecution> runs) {
        this.runs = runs;
    }

    @NonNull
    private JSONObject calculate(Run<?, ?> run, AgentExecution execution) {
        JSONObject element = new JSONObject();
        BallColor iconColor = run.getIconColor();
        element.put("iconColorOrdinal", (Object)iconColor.ordinal());
        element.put("iconColorDescription", (Object)iconColor.getDescription());
        element.put("url", (Object)run.getUrl());
        element.put("number", (Object)run.getNumber());
        element.put("consoleUrl", (Object)ConsoleUrlProvider.getRedirectUrl(run));
        element.put("iconName", (Object)run.getIconColor().getIconName());
        element.put("parentUrl", (Object)run.getParent().getUrl());
        element.put("parentFullDisplayName", (Object)Functions.breakableString((String)Functions.escape((String)run.getParent().getFullDisplayName())));
        element.put("displayName", (Object)run.getDisplayName());
        element.put("duration", (Object)run.getDuration());
        element.put("durationString", (Object)run.getDurationString());
        element.put("timestampString", (Object)run.getTimestampString());
        element.put("timestampString2", (Object)run.getTimestampString2());
        element.put("startTimeInMillis", (Object)run.getStartTimeInMillis());
        element.put("startTimeReadable", (Object)this.formatStartTime(run.getStartTimeInMillis()));
        Run.Summary buildStatusSummary = run.getBuildStatusSummary();
        element.put("buildStatusSummaryWorse", (Object)buildStatusSummary.isWorse);
        element.put("buildStatusSummaryMessage", (Object)buildStatusSummary.message);
        List causeList = run.getCauses();
        if (!causeList.isEmpty()) {
            element.put("shortDescription", (Object)((Cause)causeList.get(causeList.size() - 1)).getShortDescription());
        } else {
            element.put("shortDescription", (Object)"UnknownCause");
        }
        JSONArray flowNodes = new JSONArray();
        if (run instanceof WorkflowRun) {
            for (AgentExecution.FlowNodeExecution nodeExec : execution.getFlowNodes()) {
                if (!nodeExec.getNodeName().equals(this.computerName)) continue;
                flowNodes.add((Object)this.calculateFlowNode(nodeExec));
            }
        }
        element.put("flowNodes", (Object)flowNodes);
        return element;
    }

    private JSONObject calculateFlowNode(AgentExecution.FlowNodeExecution node) {
        JSONObject element = new JSONObject();
        element.put("duration", (Object)node.getDuration());
        element.put("durationString", (Object)node.getDurationString());
        element.put("startTime", (Object)node.getStartTimeString());
        element.put("startTimeString", (Object)node.getStartTimeSince());
        element.put("flowNodeId", (Object)node.getNodeId());
        element.put("flowNodeStatusWorse", (Object)node.getFlowNodeStatus().isWorse());
        element.put("flowNodeStatusMessage", (Object)node.getFlowNodeStatus().getMessage());
        return element;
    }

    private String formatStartTime(long startTimeInMillis) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS");
        return formatter.format(new Date(startTimeInMillis));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compute() throws Exception {
        double decay = 1.0;
        Functions functions = new Functions();
        for (AgentExecution execution : this.runs) {
            if (this.canceled()) {
                return;
            }
            Run<?, ?> run = execution.getRun();
            JSONObject element = this.calculate(run, execution);
            String runId = functions.generateId();
            if (run instanceof WorkflowRun) {
                element.put("runId", (Object)runId);
            } else {
                element.put("runId", (Object)"");
            }
            RunListTable runListTable = this;
            synchronized (runListTable) {
                this.results.add(element);
            }
            this.progress(1.0 - (decay *= 0.95));
        }
    }

    @NonNull
    protected synchronized JSON data() {
        JSONArray d = JSONArray.fromObject(this.results);
        this.results.clear();
        return d;
    }
}

