/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.agent_build_history;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Run;
import hudson.util.RunList;
import io.jenkins.plugins.agent_build_history.AgentBuildHistoryConfig;
import io.jenkins.plugins.agent_build_history.AgentExecution;
import io.jenkins.plugins.agent_build_history.BuildHistoryFileManager;
import io.jenkins.plugins.agent_build_history.RunListTable;
import jakarta.servlet.http.Cookie;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.Timer;
import org.jenkinsci.plugins.workflow.actions.BodyInvocationAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.DepthFirstScanner;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.support.actions.WorkspaceActionImpl;
import org.jenkinsci.plugins.workflow.support.steps.ExecutorStep;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;

@Restricted(value={NoExternalUse.class})
public class AgentBuildHistory
implements Action {
    private static final Logger LOGGER = Logger.getLogger(AgentBuildHistory.class.getName());
    private final Computer computer;
    private int totalPages = 1;
    private static boolean loaded = false;
    private static boolean loadingComplete = false;

    public AgentBuildHistory(Computer computer) {
        this.computer = computer;
        LOGGER.log(Level.CONFIG, () -> "Creating AgentBuildHistory for " + computer.getName());
    }

    public static String getCookieValue(StaplerRequest2 req, String name, String defaultValue) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie.getValue();
            }
        }
        return defaultValue;
    }

    public Computer getComputer() {
        return this.computer;
    }

    public boolean isLoadingComplete() {
        return loadingComplete;
    }

    public static void setLoaded(boolean loaded) {
        AgentBuildHistory.loaded = loaded;
        loadingComplete = loaded;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public RunListTable getHandler() {
        if (!loaded) {
            loaded = true;
            Timer.get().schedule(AgentBuildHistory::load, 0L, TimeUnit.SECONDS);
        }
        RunListTable runListTable = new RunListTable(this.computer.getName());
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        int page = req.getParameter("page") != null ? Integer.parseInt(req.getParameter("page")) : 1;
        int pageSize = req.getParameter("pageSize") != null ? Integer.parseInt(req.getParameter("pageSize")) : Integer.parseInt(AgentBuildHistory.getCookieValue(req, "pageSize", "20"));
        String sortColumn = req.getParameter("sortColumn") != null ? req.getParameter("sortColumn") : AgentBuildHistory.getCookieValue(req, "sortColumn", "startTime");
        String sortOrder = req.getParameter("sortOrder") != null ? req.getParameter("sortOrder") : AgentBuildHistory.getCookieValue(req, "sortOrder", "desc");
        int totalEntries = BuildHistoryFileManager.readIndexFile(this.computer.getName(), AgentBuildHistoryConfig.get().getStorageDir()).size();
        this.totalPages = (int)Math.ceil((double)totalEntries / (double)pageSize);
        LOGGER.finer("Getting runs for node: " + this.computer.getName() + " page: " + page + " pageSize: " + pageSize + " sortColumn: " + sortColumn + " sortOrder: " + sortOrder);
        int start = (page - 1) * pageSize;
        runListTable.setRuns(this.getExecutionsForNode(this.computer.getName(), start, pageSize, sortColumn, sortOrder));
        return runListTable;
    }

    public List<AgentExecution> getExecutionsForNode(String nodeName, int start, int limit, String sortColumn, String sortOrder) {
        String storageDir = AgentBuildHistoryConfig.get().getStorageDir();
        List<String> indexLines = BuildHistoryFileManager.readIndexFile(nodeName, storageDir);
        LOGGER.finer("Found " + indexLines.size() + " entries for node " + nodeName);
        if (indexLines.isEmpty()) {
            return List.of();
        }
        indexLines.sort((a, b) -> {
            int comparison = 0;
            switch (sortColumn) {
                case "startTime": {
                    long timeA = Long.parseLong(a.split(";")[2]);
                    long timeB = Long.parseLong(b.split(";")[2]);
                    comparison = Long.compare(timeA, timeB);
                    break;
                }
                case "build": {
                    comparison = a.split(";")[0].compareTo(b.split(";")[0]);
                    if (comparison != 0) break;
                    int buildNumberA = Integer.parseInt(a.split(";")[1]);
                    int buildNumberB = Integer.parseInt(b.split(";")[1]);
                    comparison = Integer.compare(buildNumberA, buildNumberB);
                    break;
                }
                default: {
                    comparison = 0;
                }
            }
            return sortOrder.equals("asc") ? comparison : -comparison;
        });
        int end = Math.min(start + limit, indexLines.size());
        List<String> page = indexLines.subList(start, end);
        ArrayList<AgentExecution> result = new ArrayList<AgentExecution>();
        for (String line : page) {
            int buildNumber;
            String[] parts = line.split(";");
            String jobName = parts[0];
            AgentExecution execution = AgentBuildHistory.loadSingleExecution(jobName, buildNumber = Integer.parseInt(parts[1]));
            if (execution == null) continue;
            result.add(execution);
        }
        LOGGER.finer("Returning " + result.size() + " entries for node " + nodeName);
        return result;
    }

    public static AgentExecution loadSingleExecution(String jobName, int buildNumber) {
        Job job = (Job)Jenkins.get().getItemByFullName(jobName, Job.class);
        Run run = null;
        if (job != null) {
            run = job.getBuildByNumber(buildNumber);
        }
        if (run == null) {
            LOGGER.info("Run not found for " + jobName + " #" + buildNumber);
            return null;
        }
        LOGGER.finer("Loading run " + run.getFullDisplayName());
        AgentExecution execution = new AgentExecution(run);
        if (run instanceof AbstractBuild) {
            AbstractBuild build = (AbstractBuild)run;
            Node node = build.getBuiltOn();
            if (node != null) {
                LOGGER.finer("Loading AbstractBuild on node: " + node.getNodeName());
                return execution;
            }
        } else if (run instanceof WorkflowRun) {
            WorkflowRun wfr = (WorkflowRun)run;
            LOGGER.finer("Loading WorkflowRun: " + wfr.getFullDisplayName());
            FlowExecution flowExecution = wfr.getExecution();
            if (flowExecution != null) {
                block0: for (FlowNode flowNode : new DepthFirstScanner().allNodes(flowExecution)) {
                    StepStartNode startNode;
                    StepDescriptor descriptor;
                    if (!(flowNode instanceof StepStartNode) || !((descriptor = (startNode = (StepStartNode)flowNode).getDescriptor()) instanceof ExecutorStep.DescriptorImpl) || flowNode.getActions(BodyInvocationAction.class).isEmpty()) continue;
                    for (FlowNode parent : flowNode.getParents()) {
                        WorkspaceActionImpl action;
                        if (!(parent instanceof StepStartNode)) continue;
                        StepStartNode parentNode = (StepStartNode)parent;
                        StepDescriptor parentDescriptor = parentNode.getDescriptor();
                        if (!(parentDescriptor instanceof ExecutorStep.DescriptorImpl) || (action = (WorkspaceActionImpl)parentNode.getAction(WorkspaceActionImpl.class)) == null) continue block0;
                        String nodeName = action.getNode();
                        execution.addFlowNode(flowNode, nodeName);
                        LOGGER.finer("Loading WorkflowRun FlowNode on node: " + nodeName);
                        continue block0;
                    }
                }
            }
        }
        return execution;
    }

    private static void load() {
        LOGGER.log(Level.INFO, () -> "Starting to synchronize all runs");
        RunList runList = RunList.fromJobs((Iterable)Jenkins.get().allItems(Job.class));
        runList.forEach(run -> {
            WorkflowRun wfr;
            FlowExecution flowExecution;
            LOGGER.finer("Loading run " + run.getFullDisplayName());
            if (run instanceof AbstractBuild) {
                AbstractBuild build = (AbstractBuild)run;
                Node node = build.getBuiltOn();
                if (node != null) {
                    BuildHistoryFileManager.addRunToNodeIndex(node.getNodeName(), run, AgentBuildHistoryConfig.get().getStorageDir());
                }
            } else if (run instanceof WorkflowRun && (flowExecution = (wfr = (WorkflowRun)run).getExecution()) != null) {
                for (FlowNode flowNode : new DepthFirstScanner().allNodes(flowExecution)) {
                    if (!(flowNode instanceof StepStartNode)) continue;
                    StepStartNode startNode = (StepStartNode)flowNode;
                    for (WorkspaceActionImpl action : flowNode.getActions(WorkspaceActionImpl.class)) {
                        StepDescriptor descriptor = startNode.getDescriptor();
                        if (!(descriptor instanceof ExecutorStep.DescriptorImpl)) continue;
                        String nodeName = action.getNode();
                        BuildHistoryFileManager.addRunToNodeIndex(nodeName, run, AgentBuildHistoryConfig.get().getStorageDir());
                    }
                }
            }
        });
        loadingComplete = true;
        LOGGER.log(Level.INFO, () -> "Synchronizing all runs complete");
    }

    public static void startJobExecution(Computer c, Run<?, ?> run) {
        BuildHistoryFileManager.addRunToNodeIndex(c.getName(), run, AgentBuildHistoryConfig.get().getStorageDir());
    }

    public static void startFlowNodeExecution(Computer c, WorkflowRun run, FlowNode node) {
        BuildHistoryFileManager.addRunToNodeIndex(c.getName(), run, AgentBuildHistoryConfig.get().getStorageDir());
    }

    public String getIconFileName() {
        return "symbol-file-tray-stacked-outline plugin-ionicons-api";
    }

    public String getDisplayName() {
        return "Extended Build History";
    }

    public String getUrlName() {
        return "extendedBuildHistory";
    }
}

