/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opsbox.utility.parameter;

import hudson.Extension;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.SimpleParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.util.FormValidation;
import hudson.util.RunList;
import io.jenkins.plugins.opsbox.utility.parameter.Messages;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.verb.POST;

public class JobBuildNameParameterDefinition
extends SimpleParameterDefinition {
    private static final String DEFAULT_BUILD_NAME = "0.0.1-1+999";
    private static final int DEFAULT_MAX_BUILD_COUNT = 5;
    private String jobName;
    private int maxBuildCount;
    private final String defaultValue;

    @DataBoundConstructor
    public JobBuildNameParameterDefinition(String name, String jobName, String description) {
        super(name);
        this.setDescription(description);
        this.jobName = jobName;
        this.maxBuildCount = 5;
        this.defaultValue = DEFAULT_BUILD_NAME;
    }

    public int getMaxBuildCount() {
        return this.maxBuildCount == 0 ? 5 : this.maxBuildCount;
    }

    @DataBoundSetter
    public void setMaxBuildCount(int maxBuildCount) {
        this.maxBuildCount = maxBuildCount;
    }

    public JobBuildNameParameterDefinition(String name, String jobName, int maxBuildCount, String defaultValue, String description) {
        super(name);
        this.setDescription(description);
        this.jobName = jobName;
        this.maxBuildCount = maxBuildCount;
        this.defaultValue = defaultValue;
    }

    private static <T extends Item> T find(String jobName, Class<T> type) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            return null;
        }
        Item item = jenkins.getItemByFullName(jobName, type);
        if (item != null) {
            item.checkPermission(Item.READ);
        } else {
            for (Item allItem : jenkins.getAllItems(type)) {
                if (!allItem.getName().equals(jobName)) continue;
                allItem.checkPermission(Item.READ);
                item = allItem;
                break;
            }
        }
        return (T)item;
    }

    private static List<String> getBuildNames(String jobName, int maxBuildCount) {
        Job job = JobBuildNameParameterDefinition.find(jobName, Job.class);
        if (job == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> buildNames = new ArrayList<String>();
        RunList runList = job.getBuilds().newBuilds();
        for (Run run : runList) {
            Result result;
            if (buildNames.size() >= maxBuildCount) break;
            if (run.isBuilding() || (result = run.getResult()) == null || !result.isBetterOrEqualTo(Result.SUCCESS)) continue;
            buildNames.add(run.getDisplayName());
        }
        return buildNames;
    }

    @Exported
    public List<String> getChoices() {
        List<String> choices = JobBuildNameParameterDefinition.getBuildNames(this.jobName, this.maxBuildCount);
        if (choices.isEmpty()) {
            choices.add(DEFAULT_BUILD_NAME);
        }
        return choices;
    }

    public StringParameterValue getDefaultParameterValue() {
        List<String> choices = this.getChoices();
        return new StringParameterValue(this.getName(), this.defaultValue == null ? choices.get(0) : this.defaultValue, this.getDescription());
    }

    public ParameterValue createValue(StaplerRequest2 req, JSONObject jo) {
        StringParameterValue value = (StringParameterValue)req.bindJSON(StringParameterValue.class, jo);
        value.setDescription(this.getDescription());
        return value;
    }

    public StringParameterValue createValue(String value) {
        return new StringParameterValue(this.getName(), value, this.getDescription());
    }

    @Generated
    public String getJobName() {
        return this.jobName;
    }

    @Extension
    @Symbol(value={"jobBuildNameParam"})
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        @Nonnull
        public String getDisplayName() {
            return Messages.JobBuildNameParameterDefinition_DisplayName();
        }

        @POST
        public FormValidation doCheckJobName(@QueryParameter String jobName, @AncestorInPath Item item) {
            item.checkPermission(Item.READ);
            String errorMsg = Messages.JobBuildNameParameterDefinition_jobNotExists();
            Job job = JobBuildNameParameterDefinition.find(jobName, Job.class);
            if (job == null) {
                return FormValidation.error((String)errorMsg);
            }
            return FormValidation.ok();
        }

        public AutoCompletionCandidates doAutoCompleteJobName(@QueryParameter String value) {
            AutoCompletionCandidates candidates = new AutoCompletionCandidates();
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins == null) {
                return candidates;
            }
            List allJobs = jenkins.getAllItems(Job.class);
            for (Job job : allJobs) {
                String jobFullName = job.getFullName();
                if (value != null && !value.trim().isEmpty()) {
                    if (!jobFullName.toLowerCase().contains(value.toLowerCase())) continue;
                    candidates.add(jobFullName);
                    continue;
                }
                candidates.add(jobFullName);
            }
            return candidates;
        }
    }
}

