/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opsbox.utility.contributor;

import com.google.common.collect.Maps;
import com.syhuang.hudson.plugins.listgitbranchesparameter.ListGitBranchesParameterDefinition;
import com.syhuang.hudson.plugins.listgitbranchesparameter.ListGitBranchesParameterValue;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.EnvironmentContributor;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

@Extension
public class ListGitBranchesEnvironmentContributor
extends EnvironmentContributor {
    private static final Logger LOGGER = Logger.getLogger(ListGitBranchesEnvironmentContributor.class.getName());

    public void buildEnvironmentFor(Run run, EnvVars envVars, TaskListener listener) {
        Map<String, String> values;
        Map<String, String> configs = this.getParametersConfigs(run);
        if (!configs.isEmpty()) {
            envVars.putAll(configs);
        }
        if (!(values = this.getParametersValue(run)).isEmpty()) {
            envVars.putAll(values);
        }
    }

    public static String cleanBranchName(String branch) {
        if (branch == null || branch.isEmpty()) {
            return branch;
        }
        if (branch.startsWith("refs/heads/")) {
            return branch.replace("refs/heads/", "");
        }
        if (branch.startsWith("refs/tags/")) {
            return branch.replace("refs/tags/", "");
        }
        return branch;
    }

    private Map<String, String> getParametersValue(Run<?, ?> run) {
        HashMap params = Maps.newHashMap();
        ParametersAction parametersAction = (ParametersAction)run.getAction(ParametersAction.class);
        if (parametersAction != null) {
            for (ParameterValue param : parametersAction.getParameters()) {
                if (!(param instanceof ListGitBranchesParameterValue)) continue;
                params.put(param.getName(), ListGitBranchesEnvironmentContributor.cleanBranchName(param.getValue().toString()));
            }
        }
        return params;
    }

    private Map<String, String> getParametersConfigs(Run<?, ?> run) {
        HashMap params = Maps.newHashMap();
        Job job = run.getParent();
        ParametersDefinitionProperty paramProp = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class);
        if (paramProp == null) {
            LOGGER.fine("Job does not have any parameter definitions.");
            return params;
        }
        List parameterDefinitions = paramProp.getParameterDefinitions();
        if (parameterDefinitions == null || parameterDefinitions.isEmpty()) {
            LOGGER.fine("No parameters defined in the job.");
            return params;
        }
        for (ParameterDefinition pd : parameterDefinitions) {
            if (!(pd instanceof ListGitBranchesParameterDefinition)) continue;
            ListGitBranchesParameterDefinition gitParamDef = (ListGitBranchesParameterDefinition)pd;
            String remoteUrl = gitParamDef.getRemoteURL();
            String credentialsId = gitParamDef.getCredentialsId();
            LOGGER.fine("Found Git remote URL: " + remoteUrl);
            if (remoteUrl != null) {
                params.put(String.format("PARAMS__%s__REMOTE_URL", gitParamDef.getName()), remoteUrl);
            }
            if (credentialsId == null || credentialsId.trim().isEmpty()) continue;
            params.put(String.format("PARAMS__%s__CREDENTIALS_ID", gitParamDef.getName()), credentialsId);
        }
        return params;
    }
}

