// CHECKSTYLE:OFF

package io.jenkins.plugins.opsbox.utility.parameter;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code JobBuildNameParameterDefinition.DisplayName}: {@code Job
     * Build Name Parameter}.
     * 
     * @return
     *     {@code Job Build Name Parameter}
     */
    public static String JobBuildNameParameterDefinition_DisplayName() {
        return holder.format("JobBuildNameParameterDefinition.DisplayName");
    }

    /**
     * Key {@code JobBuildNameParameterDefinition.DisplayName}: {@code Job
     * Build Name Parameter}.
     * 
     * @return
     *     {@code Job Build Name Parameter}
     */
    public static Localizable _JobBuildNameParameterDefinition_DisplayName() {
        return new Localizable(holder, "JobBuildNameParameterDefinition.DisplayName");
    }

    /**
     * Key {@code JobBuildNameParameterDefinition.jobNotExists}: {@code Job
     * doesn''t exist}.
     * 
     * @return
     *     {@code Job doesn''t exist}
     */
    public static String JobBuildNameParameterDefinition_jobNotExists() {
        return holder.format("JobBuildNameParameterDefinition.jobNotExists");
    }

    /**
     * Key {@code JobBuildNameParameterDefinition.jobNotExists}: {@code Job
     * doesn''t exist}.
     * 
     * @return
     *     {@code Job doesn''t exist}
     */
    public static Localizable _JobBuildNameParameterDefinition_jobNotExists() {
        return new Localizable(holder, "JobBuildNameParameterDefinition.jobNotExists");
    }

}
