/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.api.util;

import io.jenkins.plugins.opentelemetry.api.ReconfigurableOpenTelemetry;
import io.jenkins.plugins.opentelemetry.api.logs.TestLogRecordData;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import java.time.Instant;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OpenTelemetryUtils {
    private static final Logger logger = Logger.getLogger(OpenTelemetryUtils.class.getName());

    public static boolean isOtelInstrumentationEnabled(String instrumentationName) {
        boolean defaultEnabled = OpenTelemetryUtils.getProperty("otel.instrumentation.common.default-enabled", true);
        return OpenTelemetryUtils.getProperty("otel.instrumentation." + instrumentationName + ".enabled", defaultEnabled);
    }

    static boolean getProperty(String propertyName, boolean defaultValue) {
        String systemPropertyValue = System.getProperty(propertyName);
        if (systemPropertyValue != null) {
            return "true".equalsIgnoreCase(systemPropertyValue);
        }
        String envVar = propertyName.replace('.', '_').replace('-', '_').toUpperCase();
        String envVarValue = System.getenv(envVar);
        if (envVarValue != null) {
            return "true".equalsIgnoreCase(envVarValue);
        }
        return defaultValue;
    }

    public static String testLogRecordExporter() {
        ReconfigurableOpenTelemetry openTelemetry = ReconfigurableOpenTelemetry.get();
        TestLogRecordData logRecordData = TestLogRecordData.builder().setTimestamp(Instant.now()).setResource(openTelemetry.getResource()).setSeverityText(Severity.INFO.name()).setSeverity(Severity.INFO).setInstrumentationScopeInfo(InstrumentationScopeInfo.create((String)"io.jenkins.opentelemetry.api")).setBody("Test log record").build();
        CompletableResultCode result = openTelemetry.getLogRecordExporter().export(Collections.singleton(logRecordData));
        result.join(1L, TimeUnit.SECONDS);
        String resultMessage = "testLogRecordExporter(): result(success: " + result.isSuccess() + "done: " + result.isDone() + "), " + String.valueOf(openTelemetry.getLogRecordExporter()) + ", " + String.valueOf(logRecordData) + " -";
        logger.log(Level.INFO, resultMessage);
        return resultMessage;
    }

    private OpenTelemetryUtils() {
    }
}

