/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.api;

import com.google.common.base.Function;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import io.jenkins.plugins.opentelemetry.api.ConfigPropertiesUtils;
import io.jenkins.plugins.opentelemetry.api.ExtendedOpenTelemetry;
import io.jenkins.plugins.opentelemetry.api.OpenTelemetryLifecycleListener;
import io.jenkins.plugins.opentelemetry.api.ReconfigurableLoggerProvider;
import io.jenkins.plugins.opentelemetry.api.ReconfigurableMeterProvider;
import io.jenkins.plugins.opentelemetry.api.ReconfigurableTracerProvider;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.logs.LoggerProvider;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterBuilder;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerBuilder;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import io.opentelemetry.sdk.resources.Resource;
import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.PreDestroy;

public class ReconfigurableOpenTelemetry
implements ExtendedOpenTelemetry,
OpenTelemetry,
Closeable,
ExtensionPoint {
    private static final Logger logger = Logger.getLogger(ReconfigurableOpenTelemetry.class.getName());
    private static final ReconfigurableOpenTelemetry INSTANCE = new ReconfigurableOpenTelemetry();
    private static final AtomicInteger GET_INVOCATION_COUNT = new AtomicInteger(0);
    private static final String NONE = "none";
    Resource resource = Resource.empty();
    ConfigProperties config = ConfigPropertiesUtils.emptyConfig();
    OpenTelemetry openTelemetryImpl = OpenTelemetry.noop();
    LogRecordExporter logRecordExporter = NoopLogRecordExporter.getInstance();
    Thread shutdownHook;
    final ReconfigurableMeterProvider meterProviderImpl = new ReconfigurableMeterProvider();
    final ReconfigurableTracerProvider traceProviderImpl = new ReconfigurableTracerProvider();
    final ReconfigurableLoggerProvider loggerProviderImpl = new ReconfigurableLoggerProvider();

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED, before=InitMilestone.SYSTEM_CONFIG_LOADED)
    public static void init() {
        logger.log(Level.FINE, () -> "OpenTelemetry configured as NoOp: " + String.valueOf(INSTANCE));
    }

    @Extension(ordinal=2.147483647E9)
    public static ReconfigurableOpenTelemetry get() {
        int getInvocationCount = GET_INVOCATION_COUNT.incrementAndGet();
        logger.log(Level.FINE, () -> "get(invocationCount=" + getInvocationCount + "): " + String.valueOf(INSTANCE));
        return INSTANCE;
    }

    public ReconfigurableOpenTelemetry() {
        try {
            GlobalOpenTelemetry.set((OpenTelemetry)this);
        }
        catch (IllegalStateException e) {
            logger.log(Level.WARNING, "GlobalOpenTelemetry already set", e);
        }
        logger.log(Level.FINE, () -> "Configure GlobalOpenTelemetry with instance " + String.valueOf(Optional.of(GlobalOpenTelemetry.get()).map(ot -> String.valueOf(ot) + "@" + System.identityHashCode(ot))));
    }

    @Override
    @Deprecated
    public void configure(@NonNull Map<String, String> openTelemetryProperties, Resource openTelemetryResource) {
        this.configure(openTelemetryProperties, openTelemetryResource, true);
    }

    @Override
    public void configure(@NonNull Map<String, String> openTelemetryProperties, Resource openTelemetryResource, boolean disableShutdownHook) {
        String endpoint = openTelemetryProperties.getOrDefault("otel.exporter.otlp.endpoint", NONE);
        if (NONE.equalsIgnoreCase(endpoint)) {
            endpoint = openTelemetryProperties.getOrDefault("otel.exporter.otlp.traces.endpoint", NONE);
        }
        String tracesExporter = openTelemetryProperties.getOrDefault("otel.traces.exporter", NONE);
        String logsExporter = openTelemetryProperties.getOrDefault("otel.logs.exporter", NONE);
        String metricsExporter = openTelemetryProperties.getOrDefault("otel.metrics.exporter", NONE);
        if (!(NONE.equalsIgnoreCase(endpoint) && NONE.equalsIgnoreCase(tracesExporter) && NONE.equalsIgnoreCase(logsExporter) && NONE.equalsIgnoreCase(metricsExporter))) {
            logger.log(Level.FINE, "initializeOtlp");
            OpenTelemetrySdk openTelemetrySdk = AutoConfiguredOpenTelemetrySdk.builder().addPropertiesCustomizer((java.util.function.Function)((Function)configProperties -> {
                if (logger.isLoggable(Level.INFO)) {
                    for (Map.Entry keyValue : openTelemetryProperties.entrySet()) {
                        if (configProperties.getString((String)keyValue.getKey()) == null) continue;
                        logger.log(Level.INFO, "Overwrite OTel SDK property: " + (String)keyValue.getKey() + "=" + configProperties.getString((String)keyValue.getKey()) + " with Jenkins Plugin property: " + (String)keyValue.getValue());
                    }
                }
                return openTelemetryProperties;
            })).addPropertiesCustomizer((java.util.function.Function)((Function)configProperties -> {
                this.config = configProperties;
                return Collections.emptyMap();
            })).addResourceCustomizer((resource1, configProperties) -> {
                this.resource = Resource.builder().putAll(resource1).putAll(openTelemetryResource).build();
                return this.resource;
            }).addLogRecordExporterCustomizer((logRecordExporter, configProperties) -> {
                this.logRecordExporter = logRecordExporter;
                return logRecordExporter;
            }).disableShutdownHook().build().getOpenTelemetrySdk();
            this.setOpenTelemetryImpl((OpenTelemetry)openTelemetrySdk);
            if (disableShutdownHook) {
                if (this.shutdownHook != null) {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
            } else if (this.shutdownHook == null) {
                this.shutdownHook = new Thread(this::close, "Reconfigurable OpenTelemetry SDK Shutdown Hook");
                Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            }
            logger.log(Level.INFO, () -> "OpenTelemetry configured: " + ConfigPropertiesUtils.prettyPrintOtelSdkConfig(this.config, this.resource));
        } else {
            this.resource = Resource.empty();
            this.config = ConfigPropertiesUtils.emptyConfig();
            this.setOpenTelemetryImpl(OpenTelemetry.noop());
            this.logRecordExporter = NoopLogRecordExporter.getInstance();
            logger.log(Level.FINE, () -> "OpenTelemetry configured as NoOp");
        }
        this.postOpenTelemetrySdkConfiguration();
    }

    protected void setOpenTelemetryImpl(OpenTelemetry openTelemetryImpl) {
        if (this.openTelemetryImpl instanceof OpenTelemetrySdk) {
            logger.log(Level.FINE, () -> "Shutdown OTel SDK...");
            CompletableResultCode shutdown = ((OpenTelemetrySdk)this.openTelemetryImpl).shutdown();
            if (!shutdown.join(1L, TimeUnit.SECONDS).isSuccess()) {
                logger.log(Level.WARNING, "Failure to shutdown OTel SDK");
            }
        }
        this.openTelemetryImpl = openTelemetryImpl;
        this.meterProviderImpl.setDelegate(openTelemetryImpl.getMeterProvider());
        this.traceProviderImpl.setDelegate(openTelemetryImpl.getTracerProvider());
        this.loggerProviderImpl.setDelegate(openTelemetryImpl.getLogsBridge());
    }

    @Override
    @PreDestroy
    public void close() {
        logger.log(Level.FINE, "Shutdown...");
        if (this.openTelemetryImpl instanceof OpenTelemetrySdk) {
            logger.log(Level.FINE, () -> "Shutdown OTel SDK...");
            CompletableResultCode shutdown = ((OpenTelemetrySdk)this.openTelemetryImpl).shutdown();
            if (!shutdown.join(1L, TimeUnit.SECONDS).isSuccess()) {
                logger.log(Level.WARNING, "Failure to shutdown OTel SDK");
            }
        }
        GlobalOpenTelemetry.resetForTest();
    }

    public TracerProvider getTracerProvider() {
        return this.traceProviderImpl;
    }

    public Tracer getTracer(String instrumentationScopeName) {
        return this.traceProviderImpl.get(instrumentationScopeName);
    }

    public Tracer getTracer(String instrumentationScopeName, String instrumentationScopeVersion) {
        return this.traceProviderImpl.get(instrumentationScopeName, instrumentationScopeVersion);
    }

    public TracerBuilder tracerBuilder(String instrumentationScopeName) {
        return this.traceProviderImpl.tracerBuilder(instrumentationScopeName);
    }

    public MeterProvider getMeterProvider() {
        return this.meterProviderImpl;
    }

    public Meter getMeter(String instrumentationScopeName) {
        return this.meterProviderImpl.get(instrumentationScopeName);
    }

    public MeterBuilder meterBuilder(String instrumentationScopeName) {
        return this.meterProviderImpl.meterBuilder(instrumentationScopeName);
    }

    @Override
    @Deprecated
    public OpenTelemetry getImplementation() {
        return this.openTelemetryImpl;
    }

    @Override
    @NonNull
    public Resource getResource() {
        return this.resource;
    }

    @Override
    @NonNull
    public ConfigProperties getConfig() {
        return this.config;
    }

    public LoggerProvider getLogsBridge() {
        return this.loggerProviderImpl;
    }

    public ContextPropagators getPropagators() {
        return this.openTelemetryImpl.getPropagators();
    }

    public LogRecordExporter getLogRecordExporter() {
        return this.logRecordExporter;
    }

    @OverridingMethodsMustInvokeSuper
    protected void postOpenTelemetrySdkConfiguration() {
        ExtensionList.lookup(OpenTelemetryLifecycleListener.class).stream().sorted().forEach(openTelemetryLifecycleListener -> {
            logger.log(Level.FINE, () -> "Notify " + String.valueOf(openTelemetryLifecycleListener) + " after OpenTelemetry configuration");
            openTelemetryLifecycleListener.afterConfiguration(this.config);
        });
    }

    private static class NoopLogRecordExporter
    implements LogRecordExporter {
        static final NoopLogRecordExporter INSTANCE = new NoopLogRecordExporter();

        static NoopLogRecordExporter getInstance() {
            return INSTANCE;
        }

        private NoopLogRecordExporter() {
        }

        public CompletableResultCode export(Collection<LogRecordData> logs) {
            return CompletableResultCode.ofSuccess();
        }

        public CompletableResultCode flush() {
            return CompletableResultCode.ofSuccess();
        }

        public CompletableResultCode shutdown() {
            return CompletableResultCode.ofSuccess();
        }

        public String toString() {
            return "NoopLogRecordExporter";
        }
    }
}

