/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.api;

import com.google.common.annotations.VisibleForTesting;
import io.jenkins.plugins.opentelemetry.api.InstrumentationScope;
import io.opentelemetry.api.incubator.trace.ExtendedTracer;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerBuilder;
import io.opentelemetry.api.trace.TracerProvider;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;

class ReconfigurableTracerProvider
implements TracerProvider {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private TracerProvider delegate;
    private final ConcurrentMap<InstrumentationScope, ReconfigurableTracer> tracers = new ConcurrentHashMap<InstrumentationScope, ReconfigurableTracer>();

    public ReconfigurableTracerProvider() {
        this(TracerProvider.noop());
    }

    public ReconfigurableTracerProvider(TracerProvider delegate) {
        this.delegate = delegate;
    }

    public Tracer get(String instrumentationScopeName) {
        this.lock.readLock().lock();
        try {
            Tracer tracer = (Tracer)this.tracers.computeIfAbsent(new InstrumentationScope(instrumentationScopeName), instrumentationScope -> new ReconfigurableTracer(this.delegate.get(instrumentationScope.instrumentationScopeName), this.lock));
            return tracer;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setDelegate(TracerProvider delegate) {
        this.lock.writeLock().lock();
        try {
            this.delegate = delegate;
            this.tracers.forEach((instrumentationScope, reconfigurableTracer) -> {
                TracerBuilder tracerBuilder = delegate.tracerBuilder(instrumentationScope.instrumentationScopeName);
                Optional.ofNullable(instrumentationScope.instrumentationScopeVersion).ifPresent(arg_0 -> ((TracerBuilder)tracerBuilder).setInstrumentationVersion(arg_0));
                Optional.ofNullable(instrumentationScope.schemaUrl).ifPresent(arg_0 -> ((TracerBuilder)tracerBuilder).setSchemaUrl(arg_0));
                reconfigurableTracer.setDelegate(tracerBuilder.build());
            });
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracer get(String instrumentationScopeName, String instrumentationScopeVersion) {
        this.lock.readLock().lock();
        try {
            Tracer tracer = (Tracer)this.tracers.computeIfAbsent(new InstrumentationScope(instrumentationScopeName, null, instrumentationScopeVersion), instrumentationScope -> new ReconfigurableTracer(this.delegate.get(instrumentationScopeName, instrumentationScopeVersion), this.lock));
            return tracer;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public TracerBuilder tracerBuilder(String instrumentationScopeName) {
        this.lock.readLock().lock();
        try {
            ReconfigurableTracerBuilder reconfigurableTracerBuilder = new ReconfigurableTracerBuilder(this.delegate.tracerBuilder(instrumentationScopeName), instrumentationScopeName, this.lock);
            return reconfigurableTracerBuilder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public TracerProvider getDelegate() {
        this.lock.readLock().lock();
        try {
            TracerProvider tracerProvider = this.delegate;
            return tracerProvider;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @VisibleForTesting
    protected class ReconfigurableTracerBuilder
    implements TracerBuilder {
        final TracerBuilder delegate;
        final String instrumentationScopeName;
        String schemaUrl;
        String instrumentationScopeVersion;
        final ReadWriteLock lock;

        public ReconfigurableTracerBuilder(TracerBuilder delegate, String instrumentationScopeName, ReadWriteLock lock) {
            this.delegate = Objects.requireNonNull(delegate);
            this.instrumentationScopeName = Objects.requireNonNull(instrumentationScopeName);
            this.lock = lock;
        }

        public TracerBuilder setSchemaUrl(String schemaUrl) {
            this.delegate.setSchemaUrl(schemaUrl);
            this.schemaUrl = schemaUrl;
            return this;
        }

        public TracerBuilder setInstrumentationVersion(String instrumentationScopeVersion) {
            this.delegate.setInstrumentationVersion(instrumentationScopeVersion);
            this.instrumentationScopeVersion = instrumentationScopeVersion;
            return this;
        }

        public ExtendedTracer build() {
            this.lock.readLock().lock();
            try {
                InstrumentationScope instrumentationScope = new InstrumentationScope(this.instrumentationScopeName, this.schemaUrl, this.instrumentationScopeVersion);
                ExtendedTracer extendedTracer = ReconfigurableTracerProvider.this.tracers.computeIfAbsent(instrumentationScope, k -> new ReconfigurableTracer(this.delegate.build(), this.lock));
                return extendedTracer;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    @VisibleForTesting
    protected static class ReconfigurableTracer
    implements ExtendedTracer {
        final ReadWriteLock lock;
        Tracer delegate;

        public ReconfigurableTracer(Tracer delegate, ReadWriteLock lock) {
            this.lock = lock;
            this.delegate = delegate;
        }

        public SpanBuilder spanBuilder(@Nonnull String spanName) {
            this.lock.readLock().lock();
            try {
                SpanBuilder spanBuilder = this.delegate.spanBuilder(spanName);
                return spanBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public void setDelegate(Tracer delegate) {
            this.lock.writeLock().lock();
            try {
                this.delegate = delegate;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public Tracer getDelegate() {
            this.lock.readLock().lock();
            try {
                Tracer tracer = this.delegate;
                return tracer;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public boolean isEnabled() {
            this.lock.readLock().lock();
            try {
                if (this.delegate instanceof ExtendedTracer) {
                    boolean bl = ((ExtendedTracer)this.delegate).isEnabled();
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }
}

