/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.api;

import com.google.common.annotations.VisibleForTesting;
import io.jenkins.plugins.opentelemetry.api.InstrumentationScope;
import io.opentelemetry.api.incubator.events.EventBuilder;
import io.opentelemetry.api.incubator.events.EventLogger;
import io.opentelemetry.api.incubator.events.EventLoggerBuilder;
import io.opentelemetry.api.incubator.events.EventLoggerProvider;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class ReconfigurableEventLoggerProvider
implements EventLoggerProvider {
    private final ConcurrentMap<InstrumentationScope, ReconfigurableEventLogger> eventLoggers = new ConcurrentHashMap<InstrumentationScope, ReconfigurableEventLogger>();
    private EventLoggerProvider delegate = EventLoggerProvider.noop();

    ReconfigurableEventLoggerProvider() {
    }

    public EventLoggerBuilder eventLoggerBuilder(String instrumentationScopeName) {
        return new ReconfigurableEventLoggerBuilder(this.delegate.eventLoggerBuilder(instrumentationScopeName), instrumentationScopeName);
    }

    public EventLogger get(String instrumentationScopeName) {
        return this.eventLoggers.computeIfAbsent(new InstrumentationScope(instrumentationScopeName), key -> new ReconfigurableEventLogger(this.delegate.get(key.instrumentationScopeName)));
    }

    public void setDelegate(EventLoggerProvider delegateEventLoggerBuilder) {
        this.delegate = delegateEventLoggerBuilder;
        this.eventLoggers.forEach((key, reconfigurableEventLogger) -> {
            EventLoggerBuilder eventLoggerBuilder = delegateEventLoggerBuilder.eventLoggerBuilder(key.instrumentationScopeName);
            Optional.ofNullable(key.schemaUrl).ifPresent(arg_0 -> ((EventLoggerBuilder)eventLoggerBuilder).setSchemaUrl(arg_0));
            Optional.ofNullable(key.instrumentationScopeVersion).ifPresent(arg_0 -> ((EventLoggerBuilder)eventLoggerBuilder).setInstrumentationVersion(arg_0));
            reconfigurableEventLogger.delegateEventLogger = eventLoggerBuilder.build();
        });
    }

    @VisibleForTesting
    protected class ReconfigurableEventLoggerBuilder
    implements EventLoggerBuilder {
        EventLoggerBuilder delegate;
        String instrumentationScopeName;
        String schemaUrl;
        String instrumentationScopeVersion;

        public ReconfigurableEventLoggerBuilder(EventLoggerBuilder delegate, String instrumentationScopeName) {
            this.delegate = Objects.requireNonNull(delegate);
            this.instrumentationScopeName = Objects.requireNonNull(instrumentationScopeName);
        }

        public EventLoggerBuilder setSchemaUrl(String schemaUrl) {
            this.delegate.setSchemaUrl(schemaUrl);
            this.schemaUrl = schemaUrl;
            return this;
        }

        public EventLoggerBuilder setInstrumentationVersion(String instrumentationScopeVersion) {
            this.delegate.setInstrumentationVersion(instrumentationScopeVersion);
            this.instrumentationScopeVersion = instrumentationScopeVersion;
            return this;
        }

        public EventLogger build() {
            InstrumentationScope key = new InstrumentationScope(this.instrumentationScopeName, this.schemaUrl, this.instrumentationScopeVersion);
            return ReconfigurableEventLoggerProvider.this.eventLoggers.computeIfAbsent(key, k -> new ReconfigurableEventLogger(this.delegate.build()));
        }
    }

    @VisibleForTesting
    protected static class ReconfigurableEventLogger
    implements EventLogger {
        EventLogger delegateEventLogger;

        public ReconfigurableEventLogger(EventLogger delegateEventLogger) {
            this.delegateEventLogger = Objects.requireNonNull(delegateEventLogger);
        }

        public EventBuilder builder(String eventName) {
            return this.delegateEventLogger.builder(eventName);
        }
    }
}

