/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.okhttp.api;

import io.jenkins.plugins.okhttp.api.OkHttpFutureException;
import io.jenkins.plugins.okhttp.api.ResponseConverter;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public class OkHttpFuture<T>
extends CompletableFuture<T> {
    public static final ResponseConverter<Response> GET_RESPONSE = (call, response) -> response;
    private final Call call;

    public OkHttpFuture(Call call) {
        this(call, null);
    }

    public OkHttpFuture(Call call, final ResponseConverter<T> converter) {
        if (call == null) {
            throw new IllegalArgumentException("Can not create an OkHttpFuture with a null call");
        }
        this.call = call;
        this.call.enqueue(new Callback(){
            final /* synthetic */ OkHttpFuture this$0;
            {
                this.this$0 = this$0;
            }

            public void onFailure(Call call, IOException e) {
                this.this$0.completeExceptionally(new OkHttpFutureException(call, (Throwable)e));
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (converter != null) {
                    try {
                        Object parsed = converter.onResponse(call, response);
                        this.this$0.complete(parsed);
                    }
                    catch (Exception e) {
                        this.this$0.completeExceptionally(new OkHttpFutureException(call, (Throwable)e));
                    }
                }
            }
        });
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.call.cancel();
        return super.cancel(mayInterruptIfRunning);
    }
}

