/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.okhttp.api;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import hudson.ProxyConfiguration;
import io.jenkins.plugins.okhttp.api.JenkinsOkHttpClient;
import io.jenkins.plugins.okhttp.api.OkHttpFuture;
import io.jenkins.plugins.okhttp.api.OkHttpFutureException;
import io.jenkins.plugins.okhttp.api.internals.JenkinsProxySelector;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class ClientTest {
    @Rule
    public JenkinsRule jenkinsRule = new JenkinsRule();
    @Rule
    public WireMockRule server = new WireMockRule((Options)WireMockConfiguration.options().dynamicPort());
    @Rule
    public WireMockRule proxy = new WireMockRule((Options)WireMockConfiguration.options().dynamicPort().dynamicHttpsPort());

    private void secureProxy(String authenticationType, String ... authorizedUserPass) {
        this.proxy.stubFor(WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.aResponse().withStatus(407).withHeader("Proxy-Authenticate", new String[]{authenticationType})));
        if (authorizedUserPass != null && authenticationType != null && (authenticationType.toLowerCase().contains("basic") || authenticationType.equalsIgnoreCase("okhttp-preemptive"))) {
            for (String userPass : authorizedUserPass) {
                String authenticationHeaderValue = "Basic " + Base64.getEncoder().encodeToString(userPass.getBytes(StandardCharsets.UTF_8));
                this.proxy.stubFor(WireMock.get((UrlPattern)WireMock.anyUrl()).withHeader("Proxy-Authorization", WireMock.equalTo((String)authenticationHeaderValue)).willReturn(WireMock.ok((String)"Hello from proxy")));
            }
        }
    }

    @Test
    public void testHappyPath() throws ExecutionException, InterruptedException {
        this.server.stubFor(WireMock.get((String)"/").willReturn(WireMock.ok((String)"Hello")));
        OkHttpClient client = JenkinsOkHttpClient.newClientBuilder((OkHttpClient)new OkHttpClient()).connectTimeout(Duration.ofSeconds(30L)).build();
        Request request = new Request.Builder().get().url(this.server.baseUrl()).build();
        Response response = (Response)new OkHttpFuture(client.newCall(request), OkHttpFuture.GET_RESPONSE).get();
        Assert.assertTrue((String)("Request to " + String.valueOf(request.url()) + " isn't successful"), (boolean)response.isSuccessful());
    }

    @Test
    public void testInexistingUrl() throws ExecutionException, InterruptedException {
        OkHttpClient client = JenkinsOkHttpClient.newClientBuilder((OkHttpClient)new OkHttpClient()).connectTimeout(Duration.ofSeconds(30L)).build();
        Request request = new Request.Builder().get().url("https://jenkins.io-does-not-exist").build();
        Response response = (Response)new OkHttpFuture(client.newCall(request), OkHttpFuture.GET_RESPONSE).exceptionally(ex -> null).get();
        Assert.assertNull((String)"A response was sent while none was expected due to calling a non existing URL", (Object)response);
    }

    @Test
    public void testSimulatingListeners() throws ExecutionException, InterruptedException {
        this.server.stubFor(WireMock.get((String)"/").willReturn(WireMock.ok((String)"Hello")));
        OkHttpClient client = JenkinsOkHttpClient.newClientBuilder((OkHttpClient)new OkHttpClient()).connectTimeout(Duration.ofSeconds(30L)).build();
        Request request = new Request.Builder().get().url(this.server.baseUrl()).build();
        CompletableFuture result = new OkHttpFuture(client.newCall(request), (call, response) -> true).exceptionally(ex -> false);
        CompletionStage listener1 = result.thenApply(response -> Optional.of("Listener 1 OK"));
        CompletionStage listener2 = result.thenApply(response -> Optional.of("Listener 2 OK"));
        Assert.assertEquals((Object)"Listener 1 OK", ((Optional)((CompletableFuture)listener1).get()).get());
        Assert.assertEquals((Object)"Listener 2 OK", ((Optional)((CompletableFuture)listener2).get()).get());
    }

    @Test
    public void testTimeout() throws ExecutionException, InterruptedException {
        this.server.stubFor(WireMock.get((String)"/").willReturn(WireMock.aResponse().withFixedDelay(Integer.valueOf(5000)).withBody("Hello")));
        OkHttpClient client = JenkinsOkHttpClient.newClientBuilder((OkHttpClient)new OkHttpClient()).connectTimeout(Duration.ofSeconds(2L)).readTimeout(Duration.ofSeconds(2L)).build();
        Request request = new Request.Builder().get().url(this.server.baseUrl()).build();
        CompletableFuture future = new OkHttpFuture(client.newCall(request), (call, response) -> Optional.empty()).exceptionally(throwable -> Optional.of(throwable));
        Optional response2 = (Optional)future.get();
        Assert.assertTrue((boolean)response2.isPresent());
        Assert.assertEquals(OkHttpFutureException.class, ((Throwable)response2.get()).getClass());
        Assert.assertEquals(SocketTimeoutException.class, ((Throwable)response2.get()).getCause().getClass());
    }

    @Test
    public void testProxy() throws ExecutionException, InterruptedException, IOException {
        this.jenkinsRule.jenkins.setProxy(new ProxyConfiguration(InetAddress.getLoopbackAddress().getHostAddress(), this.proxy.port(), "proxy-user", "proxy-pass"));
        this.secureProxy("Basic", "proxy-user:proxy-pass");
        this.server.stubFor(WireMock.get((String)"/hello").willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.proxy.baseUrl())));
        OkHttpClient client = JenkinsOkHttpClient.newClientBuilder((OkHttpClient)new OkHttpClient()).build();
        Request request = new Request.Builder().get().url(this.server.url("/hello")).build();
        Response response = (Response)new OkHttpFuture(client.newCall(request), OkHttpFuture.GET_RESPONSE).get();
        Assert.assertEquals((long)200L, (long)response.code());
        try (ResponseBody body = response.body();){
            Assert.assertEquals((Object)"Hello from proxy", (Object)body.string());
        }
    }

    @Test
    public void testProxyWithBasicAuthAndRealm() throws ExecutionException, InterruptedException, IOException {
        this.jenkinsRule.jenkins.setProxy(new ProxyConfiguration(InetAddress.getLoopbackAddress().getHostAddress(), this.proxy.port(), "proxy-user", "proxy-pass"));
        this.secureProxy("Basic realm=\"somerealm\"", "proxy-user:proxy-pass");
        this.server.stubFor(WireMock.get((String)"/hello").willReturn((ResponseDefinitionBuilder)WireMock.aResponse().proxiedFrom(this.proxy.baseUrl())));
        OkHttpClient client = JenkinsOkHttpClient.newClientBuilder((OkHttpClient)new OkHttpClient()).build();
        Request request = new Request.Builder().get().url(this.server.url("/hello")).build();
        Response response = (Response)new OkHttpFuture(client.newCall(request), OkHttpFuture.GET_RESPONSE).get();
        Assert.assertEquals((long)200L, (long)response.code());
        try (ResponseBody body = response.body();){
            Assert.assertEquals((Object)"Hello from proxy", (Object)body.string());
        }
    }

    @Test
    public void testProxySelector() throws URISyntaxException {
        URI[] urisThatShouldNotUseProxy;
        String noProxyHosts = new StringJoiner("|").add("1.2.3.4").add("*.jenkins.io").add("my*.super-jenkins.io").toString();
        this.jenkinsRule.jenkins.setProxy(new ProxyConfiguration("127.0.0.1", this.proxy.port(), null, null, noProxyHosts));
        JenkinsProxySelector proxySelector = new JenkinsProxySelector();
        for (URI uri : urisThatShouldNotUseProxy = new URI[]{new URI("http://1.2.3.4"), new URI("http://hello-from.jenkins.io"), new URI("http://another.hello.from.jenkins.io"), new URI("http://my-wonderful.super-jenkins.io")}) {
            List proxies = proxySelector.select(uri);
            Assert.assertEquals((String)("Not only one proxy returned for URI " + String.valueOf(uri)), (long)1L, (long)proxies.size());
            Assert.assertEquals((String)("A proxy different from NO_PROXY is sent for " + String.valueOf(uri)), (Object)Proxy.NO_PROXY, proxies.get(0));
        }
    }
}

