/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.oidc_provider.config;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import io.jenkins.plugins.oidc_provider.config.ClaimTemplate;
import io.jenkins.plugins.oidc_provider.config.IntegerClaimType;
import io.jenkins.plugins.oidc_provider.config.StringClaimType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest2;

@Symbol(value={"idToken"})
@Extension
public final class IdTokenConfiguration
extends GlobalConfiguration {
    private static final List<ClaimTemplate> DEFAULT_CLAIM_TEMPLATES = Collections.emptyList();
    private static final List<ClaimTemplate> DEFAULT_BUILD_CLAIM_TEMPLATES = Collections.unmodifiableList(Arrays.asList(new ClaimTemplate("sub", "${JOB_URL}", new StringClaimType()), new ClaimTemplate("build_number", "${BUILD_NUMBER}", new IntegerClaimType())));
    private static final List<ClaimTemplate> DEFAULT_GLOBAL_CLAIM_TEMPLATES = Collections.singletonList(new ClaimTemplate("sub", "${JENKINS_URL}", new StringClaimType()));
    private int tokenLifetime = 3600;
    @CheckForNull
    private List<ClaimTemplate> claimTemplates;
    @CheckForNull
    private List<ClaimTemplate> buildClaimTemplates;
    @CheckForNull
    private List<ClaimTemplate> globalClaimTemplates;

    @NonNull
    public static IdTokenConfiguration get() {
        return (IdTokenConfiguration)((Object)ExtensionList.lookupSingleton(IdTokenConfiguration.class));
    }

    public IdTokenConfiguration() {
        this.load();
    }

    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(GlobalConfigurationCategory.Security.class);
    }

    @CheckForNull
    private static List<ClaimTemplate> defaulted(@CheckForNull List<ClaimTemplate> claimTemplates, @NonNull List<ClaimTemplate> defaultClaimTemplates) {
        if (claimTemplates == null) {
            return null;
        }
        if (ClaimTemplate.xmlForm(claimTemplates).equals(ClaimTemplate.xmlForm(defaultClaimTemplates))) {
            return null;
        }
        return new ArrayList<ClaimTemplate>(claimTemplates);
    }

    public int getTokenLifetime() {
        return this.tokenLifetime;
    }

    @DataBoundSetter
    public void setTokenLifetime(int lifetime) {
        this.tokenLifetime = lifetime;
    }

    @NonNull
    public List<ClaimTemplate> getClaimTemplates() {
        return this.claimTemplates != null ? this.claimTemplates : DEFAULT_CLAIM_TEMPLATES;
    }

    @DataBoundSetter
    public void setClaimTemplates(@CheckForNull List<ClaimTemplate> claimTemplates) {
        this.claimTemplates = IdTokenConfiguration.defaulted(claimTemplates, DEFAULT_CLAIM_TEMPLATES);
        this.save();
    }

    @NonNull
    public List<ClaimTemplate> getBuildClaimTemplates() {
        return this.buildClaimTemplates != null ? this.buildClaimTemplates : DEFAULT_BUILD_CLAIM_TEMPLATES;
    }

    @DataBoundSetter
    public void setBuildClaimTemplates(@CheckForNull List<ClaimTemplate> buildClaimTemplates) {
        this.buildClaimTemplates = IdTokenConfiguration.defaulted(buildClaimTemplates, DEFAULT_BUILD_CLAIM_TEMPLATES);
        this.save();
    }

    @NonNull
    public List<ClaimTemplate> getGlobalClaimTemplates() {
        return this.globalClaimTemplates != null ? this.globalClaimTemplates : DEFAULT_GLOBAL_CLAIM_TEMPLATES;
    }

    @DataBoundSetter
    public void setGlobalClaimTemplates(@CheckForNull List<ClaimTemplate> globalClaimTemplates) {
        this.globalClaimTemplates = IdTokenConfiguration.defaulted(globalClaimTemplates, DEFAULT_GLOBAL_CLAIM_TEMPLATES);
        this.save();
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        this.claimTemplates = null;
        this.buildClaimTemplates = null;
        this.globalClaimTemplates = null;
        return super.configure(req, json);
    }
}

