/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.oidc_provider;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.domains.Domain;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionPoint;
import hudson.model.ModelObject;
import hudson.model.Run;
import io.jenkins.plugins.oidc_provider.IdTokenCredentials;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest2;
import org.springframework.security.access.AccessDeniedException;

public abstract class Issuer {
    private static final Logger LOGGER = Logger.getLogger(Issuer.class.getName());

    @NonNull
    protected abstract ModelObject context();

    @NonNull
    public final Collection<? extends IdTokenCredentials> credentials() {
        LinkedHashMap<String, IdTokenCredentials> credentials = new LinkedHashMap<String, IdTokenCredentials>();
        for (CredentialsProvider p : CredentialsProvider.enabled((Object)this.context())) {
            CredentialsStore store = p.getStore(this.context());
            if (store == null) continue;
            LOGGER.fine(() -> "found " + String.valueOf(store) + " for " + String.valueOf(this.context()));
            for (Credentials c : store.getCredentials(Domain.global())) {
                if (!(c instanceof IdTokenCredentials)) continue;
                IdTokenCredentials itc = (IdTokenCredentials)c;
                credentials.putIfAbsent(itc.getId(), itc);
            }
        }
        LOGGER.fine(() -> "in " + String.valueOf(this.context()) + " found " + String.valueOf(credentials.keySet()));
        return credentials.values();
    }

    @NonNull
    protected abstract String uri();

    public final String url() {
        return Jenkins.get().getRootUrl() + "oidc" + this.uri();
    }

    protected abstract void checkExtendedReadPermission() throws AccessDeniedException;

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.url() + "]";
    }

    public static interface Factory
    extends ExtensionPoint {
        @CheckForNull
        public Issuer forUri(@NonNull String var1);

        @NonNull
        public Collection<? extends Issuer> forContext(@NonNull Run<?, ?> var1);

        @CheckForNull
        public Issuer forConfig(@NonNull StaplerRequest2 var1);
    }
}

