/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.oidc_provider.config;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import io.jenkins.plugins.oidc_provider.IdTokenCredentials;
import io.jenkins.plugins.oidc_provider.config.ClaimType;
import io.jenkins.plugins.oidc_provider.config.StringClaimType;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public final class ClaimTemplate
extends AbstractDescribableImpl<ClaimTemplate> {
    @NonNull
    public final String name;
    @NonNull
    public final String format;
    @NonNull
    public final ClaimType type;

    @DataBoundConstructor
    public ClaimTemplate(String name, String format, ClaimType type) {
        this.name = name;
        this.format = format;
        this.type = type;
    }

    @Restricted(value={NoExternalUse.class})
    public String xmlForm() {
        return Jenkins.XSTREAM2.toXML((Object)this);
    }

    @Restricted(value={NoExternalUse.class})
    public static List<String> xmlForm(List<ClaimTemplate> claimTemplates) {
        return claimTemplates.stream().map(ct -> Jenkins.XSTREAM2.toXML((Object)ct)).collect(Collectors.toList());
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<ClaimTemplate> {
        public ClaimType getDefaultType() {
            return new StringClaimType();
        }

        public FormValidation doCheckName(@QueryParameter String value) {
            if (Util.fixEmpty((String)value) == null) {
                return FormValidation.error((String)"You must specify a claim name.");
            }
            if (IdTokenCredentials.STANDARD_CLAIMS.contains(value)) {
                return FormValidation.error((String)"You must not specify this standard claim.");
            }
            return FormValidation.ok();
        }
    }
}

