/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.oidc_provider;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.model.Run;
import io.jenkins.plugins.oidc_provider.Issuer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest2;
import org.springframework.security.access.AccessDeniedException;

public final class FolderIssuer
extends Issuer {
    private final ItemGroup<?> folder;

    private FolderIssuer(ItemGroup<?> folder) {
        this.folder = folder;
    }

    @Override
    @NonNull
    protected ModelObject context() {
        return this.folder;
    }

    @Override
    @NonNull
    protected String uri() {
        return Stream.of(this.folder.getFullName().split("/")).map(Util::rawEncode).collect(Collectors.joining("/job/", "/job/", ""));
    }

    @Override
    protected void checkExtendedReadPermission() throws AccessDeniedException {
        ((Item)this.folder).checkPermission(Item.READ);
    }

    @Extension
    public static final class Factory
    implements Issuer.Factory {
        @Override
        public Issuer forUri(@NonNull String uri) {
            Item folder;
            if (uri.matches("(/job/[^/]+)+") && (folder = Jenkins.get().getItemByFullName(URI.create(uri.substring(5).replace("/job/", "/")).getPath())) instanceof ItemGroup) {
                return new FolderIssuer((ItemGroup)folder);
            }
            return null;
        }

        @Override
        @NonNull
        public Collection<? extends Issuer> forContext(@NonNull Run<?, ?> context) {
            ArrayList<FolderIssuer> issuers = new ArrayList<FolderIssuer>();
            ItemGroup folder = context.getParent().getParent();
            while (folder instanceof Item) {
                issuers.add(new FolderIssuer(folder));
                folder = ((Item)folder).getParent();
            }
            return issuers;
        }

        @Override
        public Issuer forConfig(@NonNull StaplerRequest2 req) {
            ItemGroup folder = (ItemGroup)req.findAncestorObject(ItemGroup.class);
            return folder instanceof Item ? new FolderIssuer(folder) : null;
        }
    }
}

