/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.oidc_provider;

import com.cloudbees.plugins.credentials.CredentialsScope;
import hudson.Extension;
import hudson.util.Secret;
import io.jenkins.plugins.oidc_provider.IdTokenCredentials;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.FileCredentials;
import org.kohsuke.stapler.DataBoundConstructor;

public final class IdTokenFileCredentials
extends IdTokenCredentials
implements FileCredentials {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public IdTokenFileCredentials(CredentialsScope scope, String id, String description) {
        super(scope, id, description);
    }

    private IdTokenFileCredentials(CredentialsScope scope, String id, String description, KeyPair kp, Secret privateKey) {
        super(scope, id, description, kp, privateKey);
    }

    public String getFileName() {
        return "id_token";
    }

    public InputStream getContent() throws IOException {
        return new ByteArrayInputStream(this.token().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    protected IdTokenCredentials clone(KeyPair kp, Secret privateKey) {
        return new IdTokenFileCredentials(this.getScope(), this.getId(), this.getDescription(), kp, privateKey);
    }

    @Symbol(value={"idTokenFile"})
    @Extension
    public static class DescriptorImpl
    extends IdTokenCredentials.IdTokenCredentialsDescriptor {
        public String getDisplayName() {
            return "OpenID Connect id token as file";
        }
    }
}

