/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.oidc_provider;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Computer;
import hudson.model.EnvironmentContributingAction;
import hudson.model.EnvironmentContributor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.LogTaskListener;
import hudson.util.Secret;
import io.jenkins.plugins.oidc_provider.Issuer;
import io.jenkins.plugins.oidc_provider.Keys;
import io.jenkins.plugins.oidc_provider.RootIssuer;
import io.jenkins.plugins.oidc_provider.config.ClaimTemplate;
import io.jenkins.plugins.oidc_provider.config.IdTokenConfiguration;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

public abstract class IdTokenCredentials
extends BaseStandardCredentials {
    private static final Logger LOGGER = Logger.getLogger(IdTokenCredentials.class.getName());
    private static final long serialVersionUID = 1L;
    private transient KeyPair kp;
    private final Secret privateKey;
    @CheckForNull
    private String issuer;
    @CheckForNull
    private String audience;
    @CheckForNull
    private transient Run<?, ?> build;
    public static final Set<String> STANDARD_CLAIMS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("iss", "aud", "exp", "iat", "auth_time", "nonce", "acr", "amr", "azp", "nbf", "jti")));

    protected IdTokenCredentials(CredentialsScope scope, String id, String description) {
        this(scope, id, description, IdTokenCredentials.generatePrivateKey());
    }

    private static KeyPair generatePrivateKey() {
        KeyPairGenerator gen;
        try {
            gen = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException x) {
            throw new AssertionError((Object)x);
        }
        gen.initialize(2048);
        return gen.generateKeyPair();
    }

    private IdTokenCredentials(CredentialsScope scope, String id, String description, KeyPair kp) {
        this(scope, id, description, kp, IdTokenCredentials.serializePrivateKey(kp));
    }

    private static Secret serializePrivateKey(KeyPair kp) {
        assert (((RSAPublicKey)kp.getPublic()).getModulus().equals(((RSAPrivateCrtKey)kp.getPrivate()).getModulus()));
        return Secret.fromString((String)Base64.getEncoder().encodeToString(kp.getPrivate().getEncoded()));
    }

    protected IdTokenCredentials(CredentialsScope scope, String id, String description, KeyPair kp, Secret privateKey) {
        super(scope, id, description);
        this.kp = kp;
        this.privateKey = privateKey;
    }

    protected Object readResolve() throws Exception {
        KeyFactory kf = KeyFactory.getInstance("RSA");
        RSAPrivateCrtKey priv = (RSAPrivateCrtKey)kf.generatePrivate(new PKCS8EncodedKeySpec(Base64.getDecoder().decode(this.privateKey.getPlainText())));
        this.kp = new KeyPair(kf.generatePublic(new RSAPublicKeySpec(priv.getModulus(), priv.getPublicExponent())), priv);
        return this;
    }

    public final String getIssuer() {
        return this.issuer;
    }

    @DataBoundSetter
    public final void setIssuer(String issuer) {
        this.issuer = Util.fixEmpty((String)issuer);
    }

    public final String getAudience() {
        return this.audience;
    }

    @DataBoundSetter
    public final void setAudience(String audience) {
        this.audience = Util.fixEmpty((String)audience);
    }

    protected abstract IdTokenCredentials clone(KeyPair var1, Secret var2);

    public final Credentials forRun(Run<?, ?> context) {
        IdTokenCredentials clone = this.clone(this.kp, this.privateKey);
        clone.issuer = this.issuer;
        clone.audience = this.audience;
        clone.build = context;
        return clone;
    }

    RSAPublicKey publicKey() {
        return (RSAPublicKey)this.kp.getPublic();
    }

    @NonNull
    protected final String token() {
        EnvVars env;
        IdTokenConfiguration cfg = IdTokenConfiguration.get();
        JwtBuilder builder = Jwts.builder().setHeaderParam("kid", (Object)this.getId()).setIssuer(this.issuer != null ? this.issuer : this.findIssuer().url()).setAudience(this.audience).setExpiration(Date.from(Instant.now().plus((long)cfg.getTokenLifetime(), ChronoUnit.SECONDS))).setIssuedAt(new Date());
        if (this.build != null) {
            try {
                FlowExecutionOwner.Executable feoe;
                FlowExecutionOwner feo;
                LogTaskListener listener = new LogTaskListener(Logger.getLogger(IdTokenCredentials.class.getName()), Level.INFO);
                Run<?, ?> run = this.build;
                if (run instanceof FlowExecutionOwner.Executable && (feo = (feoe = (FlowExecutionOwner.Executable)run).asFlowExecutionOwner()) != null) {
                    listener = feo.getListener();
                }
                env = IdTokenCredentials.getEnvironment(this.build, (TaskListener)listener);
            }
            catch (IOException | InterruptedException x) {
                throw new RuntimeException(x);
            }
        } else {
            env = Collections.singletonMap("JENKINS_URL", Jenkins.get().getRootUrl());
        }
        AtomicBoolean definedSub = new AtomicBoolean();
        Consumer<List> addClaims = claimTemplates -> {
            for (ClaimTemplate t : claimTemplates) {
                if (STANDARD_CLAIMS.contains(t.name)) {
                    throw new SecurityException("An id token claim template must not specify " + t.name);
                }
                if (t.name.equals("sub")) {
                    definedSub.set(true);
                }
                builder.claim(t.name, t.type.parse(Util.replaceMacro((String)t.format, (Map)env)));
            }
        };
        addClaims.accept(cfg.getClaimTemplates());
        if (this.build != null) {
            addClaims.accept(cfg.getBuildClaimTemplates());
        } else {
            addClaims.accept(cfg.getGlobalClaimTemplates());
        }
        if (!definedSub.get()) {
            throw new SecurityException("An id token claim template must specify sub");
        }
        return builder.signWith((Key)this.kp.getPrivate()).compact();
    }

    private static EnvVars getEnvironment(Run<?, ?> build, TaskListener listener) throws IOException, InterruptedException {
        EnvVars env2;
        ArrayList<EnvVars> envs = new ArrayList<EnvVars>();
        Computer c = Computer.currentComputer();
        if (c != null) {
            envs.add(c.getEnvironment());
            envs.add(c.buildEnvironment(listener));
        }
        envs.add(new EnvVars(new String[]{"CLASSPATH", ""}));
        envs.add(build.getCharacteristicEnvVars());
        for (EnvironmentContributor ec : EnvironmentContributor.all()) {
            env2 = new EnvVars();
            ec.buildEnvironmentFor(build.getParent(), env2, listener);
            envs.add(env2);
            env2 = new EnvVars();
            ec.buildEnvironmentFor(build, env2, listener);
            envs.add(env2);
        }
        if (!(build instanceof AbstractBuild)) {
            for (EnvironmentContributingAction a : build.getActions(EnvironmentContributingAction.class)) {
                env2 = new EnvVars();
                a.buildEnvironment(build, env2);
                envs.add(env2);
            }
        }
        EnvVars merged = new EnvVars();
        envs.stream().flatMap(env -> env.entrySet().stream()).collect(Collectors.groupingBy(Map.Entry::getKey)).entrySet().stream().forEach(entry -> {
            Set values = ((List)entry.getValue()).stream().map(Map.Entry::getValue).collect(Collectors.toSet());
            if (values.size() == 1) {
                merged.put((String)entry.getKey(), (String)values.iterator().next());
            } else {
                listener.error("Refusing to consider conflicting values " + String.valueOf(values) + " of " + (String)entry.getKey() + " for " + String.valueOf(build));
            }
        });
        return merged;
    }

    @NonNull
    protected Issuer findIssuer() {
        Run<?, ?> context = this.build;
        if (context == null) {
            return (Issuer)ExtensionList.lookupSingleton(RootIssuer.class);
        }
        for (Issuer.Factory f : ExtensionList.lookup(Issuer.Factory.class)) {
            for (Issuer issuer : f.forContext(context)) {
                if (!issuer.credentials().contains((Object)this)) continue;
                return issuer;
            }
        }
        throw new IllegalStateException("Could not find issuer corresponding to " + this.getId() + " for " + context.getExternalizableId());
    }

    protected static abstract class IdTokenCredentialsDescriptor
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        protected IdTokenCredentialsDescriptor() {
        }

        @CheckForNull
        private static Issuer issuerFromRequest(@NonNull StaplerRequest2 req) {
            Issuer i = ExtensionList.lookup(Issuer.Factory.class).stream().map(f -> f.forConfig(req)).filter(Objects::nonNull).findFirst().orElse(null);
            if (i != null) {
                i.checkExtendedReadPermission();
            }
            return i;
        }

        public final FormValidation doCheckIssuer(StaplerRequest2 req, @QueryParameter String id, @QueryParameter String issuer) {
            Issuer i = IdTokenCredentialsDescriptor.issuerFromRequest(req);
            if (Util.fixEmpty((String)issuer) == null) {
                if (i != null) {
                    return FormValidation.okWithMarkup((String)("Issuer URI: <code>" + Util.escape((String)i.url()) + "</code>"));
                }
                return FormValidation.warning((String)"Unable to determine the issuer URI");
            }
            try {
                URI u = new URI(issuer);
                if (!"https".equals(u.getScheme())) {
                    return FormValidation.errorWithMarkup((String)"Issuer URIs should use <code>https</code> scheme");
                }
                if (u.getQuery() != null) {
                    return FormValidation.error((String)"Issuer URIs must not have a query component");
                }
                if (u.getFragment() != null) {
                    return FormValidation.error((String)"Issuer URIs must not have a fragment component");
                }
                if (u.getPath() != null && u.getPath().endsWith("/")) {
                    return FormValidation.errorWithMarkup((String)"Issuer URIs should not end with a slash (<code>/</code>) in this context");
                }
            }
            catch (URISyntaxException x) {
                return FormValidation.error((String)"Not a well-formed URI");
            }
            if (i != null) {
                IdTokenCredentials c = i.credentials().stream().filter(creds -> creds.getId().equals(id) && issuer.equals(creds.getIssuer())).findFirst().orElse(null);
                if (c != null) {
                    String base = req.getRequestURI().replaceFirst("/checkIssuer$", "");
                    return FormValidation.okWithMarkup((String)("Serve <code>" + Util.xmlEscape((String)issuer) + "/.well-known/openid-configuration</code> with <a href=\"" + base + "/wellKnownOpenidConfiguration?issuer=" + Util.escape((String)issuer) + "\" target=\"_blank\" rel=\"noopener noreferrer\">this content</a> and <code>" + Util.xmlEscape((String)issuer) + "/jwks</code> with <a href=\"" + base + "/jwks?id=" + Util.escape((String)id) + "&issuer=" + Util.escape((String)issuer) + "\" target=\"_blank\" rel=\"noopener noreferrer\">this content</a> (both as <code>application/json</code>).<br>Note that the JWKS document will need to be updated if you resave these credentials."));
                }
                return FormValidation.ok((String)"Save these credentials, then return to this screen for instructions");
            }
            return FormValidation.warning((String)"Unable to determine where these credentials are being saved");
        }

        public JSONObject doWellKnownOpenidConfiguration(@QueryParameter String issuer) {
            return Keys.openidConfiguration(issuer);
        }

        public JSONObject doJwks(StaplerRequest2 req, @QueryParameter String id, @QueryParameter String issuer) {
            Issuer i = IdTokenCredentialsDescriptor.issuerFromRequest(req);
            if (i == null) {
                throw HttpResponses.notFound();
            }
            IdTokenCredentials c = i.credentials().stream().filter(creds -> creds.getId().equals(id) && issuer.equals(creds.getIssuer())).findFirst().orElse(null);
            if (c == null) {
                throw HttpResponses.notFound();
            }
            return new JSONObject().accumulate("keys", (Object)new JSONArray().element(Keys.key(c)));
        }
    }
}

