/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.minio.download;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.minio.ClientUtil;
import io.jenkins.plugins.minio.download.MinioDownloadBuildStep;
import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.MinioClient;
import io.minio.StatObjectArgs;
import io.minio.errors.MinioException;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class MinioDownloadStepExecution {
    private final Run<?, ?> run;
    private final FilePath workspace;
    private final EnvVars env;
    private final Launcher launcher;
    private final TaskListener taskListener;
    private final MinioDownloadBuildStep step;

    public MinioDownloadStepExecution(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener taskListener, @NonNull MinioDownloadBuildStep step) {
        this.run = run;
        this.workspace = workspace;
        this.env = env;
        this.launcher = launcher;
        this.taskListener = taskListener;
        this.step = step;
    }

    public boolean start() throws Exception {
        MinioClient client = ClientUtil.getClient(this.step.getHost(), this.step.getCredentialsId(), this.run);
        if (!client.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(this.step.getBucket())).build())) {
            throw new MinioException("Bucket '" + this.step.getBucket() + "' does not exist");
        }
        String key = Optional.of(this.env.expand(this.step.getFile())).orElseThrow(MinioException::new);
        client.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(this.step.getBucket())).object(key)).build());
        String filename = Optional.of(key).map(x -> Paths.get(x, new String[0]).getFileName().toString()).orElseThrow(MinioException::new);
        Object localFilePath = "";
        if (!StringUtils.isEmpty((String)this.step.getTargetFolder())) {
            localFilePath = this.env.expand(this.step.getTargetFolder()) + File.separator;
        }
        localFilePath = (String)localFilePath + filename;
        String remoteFile = this.env.expand(this.step.getFile());
        this.taskListener.getLogger().println(String.format("Downloading %s from bucket %s", remoteFile, this.step.getBucket()));
        OutputStream fileOutputStream = this.workspace.child((String)localFilePath).write();
        GetObjectArgs getArgs = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.step.getBucket())).object(remoteFile)).build();
        GetObjectResponse minioInputStream = client.getObject(getArgs);
        byte[] buf = new byte[8192];
        int i = 0;
        while ((i = minioInputStream.read(buf)) != -1) {
            fileOutputStream.write(buf, 0, i);
        }
        return true;
    }
}

