/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.minio.delete;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.minio.ClientUtil;
import io.jenkins.plugins.minio.delete.MinioDeleteBuildStep;
import io.minio.BucketExistsArgs;
import io.minio.MinioClient;
import io.minio.RemoveObjectsArgs;
import io.minio.Result;
import io.minio.errors.MinioException;
import io.minio.messages.DeleteError;
import io.minio.messages.DeleteObject;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class MinioDeleteStepExecution {
    private static final Logger LOGGER = Logger.getLogger(MinioDeleteStepExecution.class.getName());
    private final Run<?, ?> run;
    private final FilePath workspace;
    private final EnvVars env;
    private final Launcher launcher;
    private final TaskListener taskListener;
    private final MinioDeleteBuildStep step;

    public MinioDeleteStepExecution(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener taskListener, @NonNull MinioDeleteBuildStep step) {
        this.run = run;
        this.workspace = workspace;
        this.env = env;
        this.launcher = launcher;
        this.taskListener = taskListener;
        this.step = step;
    }

    public boolean start() throws Exception {
        MinioClient client = ClientUtil.getClient(this.step.getHost(), this.step.getCredentialsId(), this.run);
        if (!client.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(this.step.getBucket())).build())) {
            throw new MinioException("Bucket '" + this.step.getBucket() + "' does not exist");
        }
        List objectsToDelete = Arrays.stream(this.step.getFiles().split(",")).map(String::trim).map(arg_0 -> ((EnvVars)this.env).expand(arg_0)).map(DeleteObject::new).collect(Collectors.toList());
        RemoveObjectsArgs args = (RemoveObjectsArgs)((RemoveObjectsArgs.Builder)RemoveObjectsArgs.builder().bucket(this.step.getBucket())).objects(objectsToDelete).build();
        Iterable results = client.removeObjects(args);
        for (Result result : results) {
            DeleteError deleteError = (DeleteError)result.get();
            this.taskListener.getLogger().println(String.format("Deleted %s from bucket %s", deleteError.resource(), this.step.getBucket()));
        }
        return true;
    }
}

