/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.minio.upload;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.minio.ClientUtil;
import io.jenkins.plugins.minio.upload.MinioBuildStep;
import io.minio.BucketExistsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.lang.StringUtils;

public class MinioStepExecution {
    private final Run<?, ?> run;
    private final FilePath workspace;
    private final EnvVars env;
    private final Launcher launcher;
    private final TaskListener taskListener;
    private final MinioBuildStep step;

    public MinioStepExecution(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener taskListener, @NonNull MinioBuildStep step) {
        this.run = run;
        this.workspace = workspace;
        this.env = env;
        this.launcher = launcher;
        this.taskListener = taskListener;
        this.step = step;
    }

    public boolean start() throws Exception {
        MinioClient client = ClientUtil.getClient(this.step.getHost(), this.step.getCredentialsId(), this.run);
        if (!client.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(this.step.getBucket())).build())) {
            client.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(this.step.getBucket())).build());
        }
        String includes = Util.replaceMacro((String)this.step.getIncludes(), (Map)this.env);
        String excludes = Util.replaceMacro((String)this.step.getExcludes(), (Map)this.env);
        Object targetFolderExpanded = Util.replaceMacro((String)this.step.getTargetFolder(), (Map)this.env);
        if (!StringUtils.isEmpty((String)targetFolderExpanded) && !((String)targetFolderExpanded).endsWith("/")) {
            targetFolderExpanded = (String)targetFolderExpanded + "/";
        }
        String targetFolder = targetFolderExpanded;
        Arrays.asList(this.workspace.list(includes, excludes)).forEach(filePath -> {
            String filename = filePath.getName();
            Path path = Paths.get(filename, new String[0]);
            String contentType = null;
            try {
                contentType = Files.probeContentType(path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (contentType == null) {
                contentType = new MimetypesFileTypeMap().getContentType(filename);
            }
            this.taskListener.getLogger().println(String.format("Storing [%s] in bucket  [%s] , mime [%s] ", filename, this.step.getBucket(), contentType));
            try {
                PutObjectArgs put = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.step.getBucket())).object(targetFolder + filename)).stream(filePath.read(), filePath.toVirtualFile().length(), -1L).contentType(contentType).build();
                client.putObject(put);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                this.run.setResult(Result.UNSTABLE);
            }
        });
        return true;
    }
}

