/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.minio.upload;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.minio.CredentialsHelper;
import io.jenkins.plugins.minio.upload.MinioStepExecution;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class MinioBuildStep
extends Builder
implements SimpleBuildStep {
    private String host;
    private String credentialsId;
    private String bucket;
    private String includes;
    private String excludes;
    private String targetFolder;

    @DataBoundConstructor
    public MinioBuildStep(String bucket, String includes) {
        this.bucket = bucket;
        this.includes = includes;
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener listener) throws AbortException {
        try {
            new MinioStepExecution(run, workspace, env, launcher, listener, this).start();
        }
        catch (Exception e) {
            run.setResult(Result.FAILURE);
            listener.getLogger().println(String.format("Problem storing objects in Minio: %s", e.getMessage()));
            e.printStackTrace();
            throw new AbortException("Failed to upload build artifacts to Minio");
        }
    }

    @DataBoundSetter
    public void setHost(String host) {
        this.host = host;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    @DataBoundSetter
    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    @DataBoundSetter
    public void setTargetFolder(String targetFolder) {
        this.targetFolder = targetFolder;
    }

    public String getHost() {
        return this.host;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public String getTargetFolder() {
        return this.targetFolder;
    }

    @Symbol(value={"minio"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId, @QueryParameter String uri) {
            return CredentialsHelper.getCredentialsListBox(item, credentialsId, uri);
        }

        @NonNull
        public String getDisplayName() {
            return "Upload build artifacts to Minio";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

