/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.minio.download;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.minio.CredentialsHelper;
import io.jenkins.plugins.minio.download.MinioDownloadStepExecution;
import io.minio.errors.ErrorResponseException;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class MinioDownloadBuildStep
extends Builder
implements SimpleBuildStep {
    private String host;
    private String credentialsId;
    private final String bucket;
    private final String file;
    private String excludes;
    private String targetFolder;
    private boolean failOnNonExisting = true;

    @DataBoundConstructor
    public MinioDownloadBuildStep(String bucket, String file) {
        this.bucket = bucket;
        this.file = file;
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener listener) throws AbortException {
        try {
            new MinioDownloadStepExecution(run, workspace, env, launcher, listener, this).start();
        }
        catch (ErrorResponseException e) {
            String code = e.errorResponse().code();
            if ((code.equals("NoSuchBucket") || code.equals("NoSuchKey")) && !this.failOnNonExisting) {
                listener.getLogger().println(String.format(String.format("File [%s] not found in bucket [%s], but failOnNonExisting = false.", env.expand(this.file), this.bucket), new Object[0]));
            } else {
                this.setFailed(run, listener, (Exception)((Object)e));
            }
        }
        catch (Exception e) {
            this.setFailed(run, listener, e);
        }
    }

    @DataBoundSetter
    public void setHost(String host) {
        this.host = host;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    @DataBoundSetter
    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    @DataBoundSetter
    public void setTargetFolder(String targetFolder) {
        this.targetFolder = targetFolder;
    }

    @DataBoundSetter
    public void setFailOnNonExisting(boolean failOnNonExisting) {
        this.failOnNonExisting = failOnNonExisting;
    }

    public String getHost() {
        return this.host;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getFile() {
        return this.file;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public String getTargetFolder() {
        return this.targetFolder;
    }

    public boolean getFailOnNonExisting() {
        return this.failOnNonExisting;
    }

    private void setFailed(@NonNull Run<?, ?> run, TaskListener listener, Exception e) throws AbortException {
        listener.getLogger().println(String.format("Problem downloading objects from Minio: %s", e.getMessage()));
        e.printStackTrace();
        throw new AbortException("Failed to download files from Minio");
    }

    @Symbol(value={"minioDownload"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId, @QueryParameter String uri) {
            return CredentialsHelper.getCredentialsListBox(item, credentialsId, uri);
        }

        @NonNull
        public String getDisplayName() {
            return "Download files from Minio";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

