/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mina_sshd_api.core.authenticators;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticatorFactory;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.Functions;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.client.auth.password.UserAuthPasswordFactory;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.session.ClientSession;

public class MinaSSHPasswordKeyAuthenticator
extends SSHAuthenticator<ClientSession, StandardUsernamePasswordCredentials> {
    static int authTimeout = Integer.parseInt(System.getProperty(MinaSSHPasswordKeyAuthenticator.class.getName() + ".authTimeout", "15"));

    MinaSSHPasswordKeyAuthenticator(@NonNull ClientSession connection, @NonNull StandardUsernamePasswordCredentials user, @CheckForNull String username) {
        super((Object)connection, (StandardUsernameCredentials)user, username);
    }

    public boolean canAuthenticate() {
        return ((ClientSession)this.getConnection()).getUserAuthFactories().stream().anyMatch(userAuthFactory -> userAuthFactory instanceof UserAuthPasswordFactory) && !((ClientSession)this.getConnection()).isAuthenticated() && ((ClientSession)this.getConnection()).isOpen();
    }

    @NonNull
    public SSHAuthenticator.Mode getAuthenticationMode() {
        return SSHAuthenticator.Mode.AFTER_CONNECT;
    }

    protected boolean doAuthenticate() {
        String username = this.getUsername();
        ((ClientSession)this.getConnection()).addPasswordIdentity(((StandardUsernamePasswordCredentials)this.getUser()).getPassword().getPlainText());
        try {
            ((ClientSession)this.getConnection()).setUsername(username);
            return ((AuthFuture)((ClientSession)this.getConnection()).auth().verify((long)authTimeout, TimeUnit.SECONDS)).isSuccess();
        }
        catch (IOException e) {
            Functions.printStackTrace((Throwable)e, (PrintWriter)this.getListener().error("Could not authenticate due to I/O issue"));
            return false;
        }
    }

    @Extension(optional=true)
    public static class Factory
    extends SSHAuthenticatorFactory {
        private static final long serialVersionUID = 1L;

        protected <C, U extends StandardUsernameCredentials> SSHAuthenticator<C, U> newInstance(@NonNull C connection, @NonNull U user) {
            return this.newInstance(connection, user, null);
        }

        @Nullable
        protected <C, U extends StandardUsernameCredentials> SSHAuthenticator<C, U> newInstance(@NonNull C connection, @NonNull U user, @CheckForNull String username) {
            if (connection instanceof ClientSession && user instanceof StandardUsernamePasswordCredentials) {
                return new MinaSSHPasswordKeyAuthenticator((ClientSession)connection, (StandardUsernamePasswordCredentials)user, username);
            }
            return null;
        }

        protected <C, U extends StandardUsernameCredentials> boolean supports(@NonNull Class<C> connectionClass, @NonNull Class<U> userClass) {
            return ClientSession.class.isAssignableFrom(connectionClass) && StandardUsernamePasswordCredentials.class.isAssignableFrom(userClass);
        }
    }
}

