/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.metrics.view;

import io.jenkins.plugins.datatables.TableColumn;
import io.jenkins.plugins.datatables.TableConfiguration;
import io.jenkins.plugins.datatables.TableModel;
import io.jenkins.plugins.metrics.model.ClassMetricsMeasurement;
import io.jenkins.plugins.metrics.model.Metric;
import io.jenkins.plugins.metrics.model.MetricDefinition;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MetricsTableModel
extends TableModel {
    private final List<MetricDefinition> supportedMetrics;
    private final List<ClassMetricsMeasurement> metricsMeasurements;
    private final String id;

    public MetricsTableModel(String id, List<MetricDefinition> supportedMetrics, List<ClassMetricsMeasurement> metricsMeasurements) {
        this.id = id;
        this.supportedMetrics = supportedMetrics;
        this.metricsMeasurements = metricsMeasurements;
    }

    public String getId() {
        return this.id;
    }

    public List<TableColumn> getColumns() {
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        columns.add(new TableColumn("Class", "className"));
        columns.addAll(this.supportedMetrics.stream().map(metricDefinition -> new TableColumn(metricDefinition.getDisplayName(), "metricsDisplay." + metricDefinition.getId())).collect(Collectors.toList()));
        return columns;
    }

    public List<Object> getRows() {
        return this.metricsMeasurements.stream().map(MetricsRow::new).collect(Collectors.toList());
    }

    public TableConfiguration getTableConfiguration() {
        return new TableConfiguration().responsive().colReorder().stateSave().buttons(new String[]{"colvis"});
    }

    public static class MetricsRow {
        private final ClassMetricsMeasurement metricsMeasurement;

        MetricsRow(ClassMetricsMeasurement metricsMeasurement) {
            this.metricsMeasurement = metricsMeasurement;
        }

        public String getName() {
            return ((ContainerTag)TagCreator.span().withTitle(this.metricsMeasurement.getPackageName())).with((DomContent)((ContainerTag)TagCreator.a().withHref(this.metricsMeasurement.getQualifiedClassName())).withText(this.metricsMeasurement.getClassName()).withTarget("blank")).render();
        }

        public Map<String, String> getMetricsDisplay() {
            return this.metricsMeasurement.getMetrics().values().stream().collect(Collectors.toMap(Metric::getId, Metric::renderValue));
        }

        public Map<String, Number> getMetricsRaw() {
            return this.metricsMeasurement.getMetrics().values().stream().collect(Collectors.toMap(Metric::getId, Metric::rawValue));
        }
    }
}

