/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.metrics.model;

import edu.hm.hafner.util.Generated;
import io.jenkins.plugins.metrics.model.Metric;
import io.jenkins.plugins.metrics.model.MetricDefinition;
import java.util.Locale;
import java.util.Objects;

public final class PercentageMetric
extends Metric {
    private static final long serialVersionUID = -239297826452518258L;
    private final float value;

    public PercentageMetric(MetricDefinition metricDefinition, float value) {
        super(metricDefinition);
        this.value = value;
    }

    @Override
    public String renderValue() {
        return String.format(Locale.ENGLISH, "%d%%", Math.round(this.value));
    }

    @Override
    public Float rawValue() {
        return Float.valueOf(this.value);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PercentageMetric that = (PercentageMetric)o;
        return Float.compare(this.value, that.value) == 0;
    }

    @Override
    @Generated
    public int hashCode() {
        return Objects.hash(super.hashCode(), Float.valueOf(this.value));
    }
}

