/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.metrics.model;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.jenkins.plugins.metrics.model.Metric;
import io.jenkins.plugins.metrics.model.MetricsMeasurement;
import java.util.Map;
import java.util.Objects;

public class MethodMetricsMeasurement
extends MetricsMeasurement {
    private static final long serialVersionUID = 6103621887323104682L;
    private final String methodName;
    private final int beginLine;
    private final int beginColumn;
    private final int endLine;
    private final int endColumn;

    private MethodMetricsMeasurement(Map<String, Metric> metrics, String fileName, String packageName, String className, String methodName, int beginLine, int beginColumn, int endLine, int endColumn) {
        super(metrics, fileName, packageName, className);
        this.methodName = methodName;
        this.beginLine = beginLine;
        this.beginColumn = beginColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    @Override
    public MethodMetricsMeasurement merge(MetricsMeasurement metricsMeasurement) {
        if (metricsMeasurement instanceof MethodMetricsMeasurement) {
            metricsMeasurement.getMetrics().values().forEach(this::merge);
        }
        return this;
    }

    public String toString() {
        return "MethodMetricsMeasurement[%s.%s#%s:%d:%d]".formatted(this.getPackageName(), this.getClassName(), this.methodName, this.beginLine, this.endLine);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodMetricsMeasurement)) {
            return false;
        }
        MethodMetricsMeasurement other = (MethodMetricsMeasurement)o;
        return this.beginLine == other.beginLine && this.beginColumn == other.beginColumn && this.endLine == other.endLine && this.endColumn == other.endColumn && Objects.equals(this.methodName, other.methodName) && Objects.equals(this.getMetrics(), other.getMetrics()) && Objects.equals(this.getClassName(), other.getClassName()) && Objects.equals(this.getFileName(), other.getFileName()) && Objects.equals(this.getPackageName(), other.getPackageName());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.beginColumn, this.beginLine, this.endLine, this.endColumn, this.methodName, this.getClassName(), this.getFileName(), this.getPackageName(), this.getMetrics());
    }

    public static class MethodMetricsMeasurementBuilder
    extends MetricsMeasurement.MetricsMeasurementBuilder<MethodMetricsMeasurementBuilder> {
        private String methodName;
        private int beginLine;
        private int beginColumn;
        private int endLine;
        private int endColumn;

        @CanIgnoreReturnValue
        public MethodMetricsMeasurementBuilder withMethodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        @CanIgnoreReturnValue
        public MethodMetricsMeasurementBuilder withBeginLine(int beginLine) {
            this.beginLine = beginLine;
            return this;
        }

        @CanIgnoreReturnValue
        public MethodMetricsMeasurementBuilder withEndLine(int endLine) {
            this.endLine = endLine;
            return this;
        }

        @CanIgnoreReturnValue
        public MethodMetricsMeasurementBuilder withBeginColumn(int beginColumn) {
            this.beginColumn = beginColumn;
            return this;
        }

        @CanIgnoreReturnValue
        public MethodMetricsMeasurementBuilder withEndColumn(int endColumn) {
            this.endColumn = endColumn;
            return this;
        }

        @Override
        public MethodMetricsMeasurement build() {
            return new MethodMetricsMeasurement(this.getMetrics(), this.getFileName(), this.getPackageName(), this.getClassName(), this.methodName, this.beginLine, this.beginColumn, this.endLine, this.endColumn);
        }
    }
}

