/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.metrics.extension;

import hudson.ExtensionPoint;
import hudson.model.Run;
import io.jenkins.plugins.metrics.extension.MetricsProvider;
import io.jenkins.plugins.metrics.model.MetricDefinition;
import io.jenkins.plugins.util.JenkinsFacade;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public abstract class MetricsProviderFactory
implements ExtensionPoint {
    public static List<MetricsProvider> findAllFor(Run<?, ?> build) {
        return MetricsProviderFactory.findFactories().stream().map(f -> f.getMetricsProviderFor(build)).toList();
    }

    public static List<MetricDefinition> findAllAvailableMetricsFor(Run<?, ?> build) {
        return MetricsProviderFactory.findFactories().stream().map(f -> f.getAvailableMetricsFor(build)).flatMap(Collection::stream).sorted().toList();
    }

    private static List<MetricsProviderFactory> findFactories() {
        return new JenkinsFacade().getExtensionsFor(MetricsProviderFactory.class);
    }

    protected abstract MetricsProvider getMetricsProviderFor(Run<?, ?> var1);

    public abstract Set<MetricDefinition> getAvailableMetricsFor(Run<?, ?> var1);
}

