/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.metrics.view;

import edu.hm.hafner.util.Generated;
import hudson.model.Run;
import io.jenkins.plugins.metrics.model.MetricDefinition;
import io.jenkins.plugins.metrics.view.MetricsView;
import java.util.Collection;
import java.util.Objects;
import org.assertj.core.annotation.CheckReturnValue;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;

@Generated(value={"assertj-assertions-generator"})
public class MetricsViewAssert
extends AbstractObjectAssert<MetricsViewAssert, MetricsView> {
    public MetricsViewAssert(MetricsView actual) {
        super((Object)actual, MetricsViewAssert.class);
    }

    @CheckReturnValue
    public static MetricsViewAssert assertThat(MetricsView actual) {
        return new MetricsViewAssert(actual);
    }

    public MetricsViewAssert hasDisplayName(String displayName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting displayName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDisplayName = ((MetricsView)this.actual).getDisplayName();
        if (!Objects.deepEquals(actualDisplayName, displayName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, displayName, actualDisplayName});
        }
        return this;
    }

    public MetricsViewAssert hasMetricsJSON(String metricsJSON) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metricsJSON of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualMetricsJSON = ((MetricsView)this.actual).getMetricsJSON();
        if (!Objects.deepEquals(actualMetricsJSON, metricsJSON)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metricsJSON, actualMetricsJSON});
        }
        return this;
    }

    public MetricsViewAssert hasOwner(Run owner) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting owner of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Run actualOwner = ((MetricsView)this.actual).getOwner();
        if (!Objects.deepEquals(actualOwner, owner)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, owner, actualOwner});
        }
        return this;
    }

    public MetricsViewAssert hasProjectOverview(String ... projectOverview) {
        this.isNotNull();
        if (projectOverview == null) {
            this.failWithMessage("Expecting projectOverview parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((MetricsView)this.actual).getProjectOverview(), (Object[])projectOverview);
        return this;
    }

    public MetricsViewAssert hasProjectOverview(Collection<? extends String> projectOverview) {
        this.isNotNull();
        if (projectOverview == null) {
            this.failWithMessage("Expecting projectOverview parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((MetricsView)this.actual).getProjectOverview(), projectOverview.toArray());
        return this;
    }

    public MetricsViewAssert hasOnlyProjectOverview(String ... projectOverview) {
        this.isNotNull();
        if (projectOverview == null) {
            this.failWithMessage("Expecting projectOverview parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((MetricsView)this.actual).getProjectOverview(), (Object[])projectOverview);
        return this;
    }

    public MetricsViewAssert hasOnlyProjectOverview(Collection<? extends String> projectOverview) {
        this.isNotNull();
        if (projectOverview == null) {
            this.failWithMessage("Expecting projectOverview parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((MetricsView)this.actual).getProjectOverview(), projectOverview.toArray());
        return this;
    }

    public MetricsViewAssert doesNotHaveProjectOverview(String ... projectOverview) {
        this.isNotNull();
        if (projectOverview == null) {
            this.failWithMessage("Expecting projectOverview parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((MetricsView)this.actual).getProjectOverview(), (Object[])projectOverview);
        return this;
    }

    public MetricsViewAssert doesNotHaveProjectOverview(Collection<? extends String> projectOverview) {
        this.isNotNull();
        if (projectOverview == null) {
            this.failWithMessage("Expecting projectOverview parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((MetricsView)this.actual).getProjectOverview(), projectOverview.toArray());
        return this;
    }

    public MetricsViewAssert hasNoProjectOverview() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have projectOverview but had :\n  <%s>";
        if (((MetricsView)this.actual).getProjectOverview().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((MetricsView)this.actual).getProjectOverview()});
        }
        return this;
    }

    public MetricsViewAssert hasSupportedMetrics(MetricDefinition ... supportedMetrics) {
        this.isNotNull();
        if (supportedMetrics == null) {
            this.failWithMessage("Expecting supportedMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((MetricsView)this.actual).getSupportedMetrics(), (Object[])supportedMetrics);
        return this;
    }

    public MetricsViewAssert hasSupportedMetrics(Collection<? extends MetricDefinition> supportedMetrics) {
        this.isNotNull();
        if (supportedMetrics == null) {
            this.failWithMessage("Expecting supportedMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((MetricsView)this.actual).getSupportedMetrics(), supportedMetrics.toArray());
        return this;
    }

    public MetricsViewAssert hasOnlySupportedMetrics(MetricDefinition ... supportedMetrics) {
        this.isNotNull();
        if (supportedMetrics == null) {
            this.failWithMessage("Expecting supportedMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((MetricsView)this.actual).getSupportedMetrics(), (Object[])supportedMetrics);
        return this;
    }

    public MetricsViewAssert hasOnlySupportedMetrics(Collection<? extends MetricDefinition> supportedMetrics) {
        this.isNotNull();
        if (supportedMetrics == null) {
            this.failWithMessage("Expecting supportedMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((MetricsView)this.actual).getSupportedMetrics(), supportedMetrics.toArray());
        return this;
    }

    public MetricsViewAssert doesNotHaveSupportedMetrics(MetricDefinition ... supportedMetrics) {
        this.isNotNull();
        if (supportedMetrics == null) {
            this.failWithMessage("Expecting supportedMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((MetricsView)this.actual).getSupportedMetrics(), (Object[])supportedMetrics);
        return this;
    }

    public MetricsViewAssert doesNotHaveSupportedMetrics(Collection<? extends MetricDefinition> supportedMetrics) {
        this.isNotNull();
        if (supportedMetrics == null) {
            this.failWithMessage("Expecting supportedMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((MetricsView)this.actual).getSupportedMetrics(), supportedMetrics.toArray());
        return this;
    }

    public MetricsViewAssert hasNoSupportedMetrics() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have supportedMetrics but had :\n  <%s>";
        if (((MetricsView)this.actual).getSupportedMetrics().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((MetricsView)this.actual).getSupportedMetrics()});
        }
        return this;
    }

    public MetricsViewAssert hasSupportedMetricsJSON(String supportedMetricsJSON) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting supportedMetricsJSON of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualSupportedMetricsJSON = ((MetricsView)this.actual).getSupportedMetricsJSON();
        if (!Objects.deepEquals(actualSupportedMetricsJSON, supportedMetricsJSON)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, supportedMetricsJSON, actualSupportedMetricsJSON});
        }
        return this;
    }
}

