/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.metrics.model;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

public final class MetricDefinition
implements Serializable,
Comparable<MetricDefinition> {
    private static final long serialVersionUID = 5311316796142816504L;
    private final String id;
    private final String displayName;
    private final String description;
    private final String reportedBy;
    private final int priority;
    private final EnumSet<Scope> scopes;

    private MetricDefinition(String id, String displayName, String description, String reportedBy, int priority, Set<Scope> scopes) {
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.reportedBy = reportedBy;
        this.priority = priority;
        this.scopes = EnumSet.copyOf(scopes);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReportedBy() {
        return this.reportedBy;
    }

    public int getPriority() {
        return this.priority;
    }

    public Set<Scope> getScopes() {
        return this.scopes;
    }

    public boolean isValidForScope(Scope scope) {
        return this.scopes.contains((Object)scope);
    }

    public String toString() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricDefinition)) {
            return false;
        }
        MetricDefinition other = (MetricDefinition)o;
        return Objects.equals(this.id, other.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Override
    public int compareTo(MetricDefinition o) {
        return this.priority - o.priority;
    }

    public static class MetricDefinitionBuilder {
        private final String id;
        private final Set<Scope> scopes = EnumSet.noneOf(Scope.class);
        private String displayName = "";
        private String description = "";
        private String reportedBy = "";
        private int priority = 0;

        public MetricDefinitionBuilder(String id) {
            this.id = id;
        }

        @CanIgnoreReturnValue
        public MetricDefinitionBuilder withDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @CanIgnoreReturnValue
        public MetricDefinitionBuilder withDescription(String description) {
            this.description = description;
            return this;
        }

        @CanIgnoreReturnValue
        public MetricDefinitionBuilder withReportedBy(String reportedBy) {
            this.reportedBy = reportedBy;
            return this;
        }

        @CanIgnoreReturnValue
        public MetricDefinitionBuilder withPriority(int priority) {
            this.priority = priority;
            return this;
        }

        @CanIgnoreReturnValue
        public MetricDefinitionBuilder withScopes(Scope ... scopes) {
            Collections.addAll(this.scopes, scopes);
            return this;
        }

        public MetricDefinition build() {
            return new MetricDefinition(this.id, this.displayName, this.description, this.reportedBy, this.priority, this.scopes);
        }
    }

    public static enum Scope {
        CLASS,
        METHOD;

    }
}

