/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.metrics.column;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.Run;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import io.jenkins.plugins.metrics.column.Messages;
import io.jenkins.plugins.metrics.extension.MetricsProviderFactory;
import io.jenkins.plugins.metrics.model.Metric;
import java.util.Optional;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ProjectMetricsColumn
extends ListViewColumn {
    private String name = "Lines of Code";
    private String metricId = "LOC";

    @DataBoundConstructor
    public ProjectMetricsColumn() {
    }

    public String getName() {
        return this.name;
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = name;
    }

    public String getMetricId() {
        return this.metricId;
    }

    @DataBoundSetter
    public void setMetricId(String metricId) {
        this.metricId = metricId;
    }

    public Optional<String> getMetricValue(Job<?, ?> job) {
        Run lastCompletedBuild = job.getLastCompletedBuild();
        if (lastCompletedBuild == null) {
            return Optional.empty();
        }
        return MetricsProviderFactory.findAllFor(lastCompletedBuild).stream().flatMap(metricsProvider -> metricsProvider.getProjectMetrics().stream()).filter(metric -> metric.getId().equals(this.metricId)).map(Metric::renderValue).findFirst();
    }

    public String getUrl(Job<?, ?> job) {
        Run lastCompletedBuild = job.getLastCompletedBuild();
        if (lastCompletedBuild == null) {
            return "";
        }
        return lastCompletedBuild.getUrl() + "metrics-aggregation";
    }

    @Extension(optional=true)
    public static class MetricsTableColumnDescriptor
    extends ListViewColumnDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.MetricsTableColumnDescriptor_Name();
        }

        public boolean shownByDefault() {
            return false;
        }
    }
}

