/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.metrics.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MetricsTreeNode {
    private String name;
    private double value;
    @JsonIgnore
    private Map<String, MetricsTreeNode> childrenMap = new HashMap<String, MetricsTreeNode>();

    public MetricsTreeNode(String name) {
        this(name, 0.0);
    }

    public MetricsTreeNode(String name, double value) {
        this.value = value;
        this.name = name;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    private void addValue(double amount) {
        this.value += amount;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public Map<String, MetricsTreeNode> getChildrenMap() {
        return this.childrenMap;
    }

    public List<MetricsTreeNode> getChildren() {
        return new ArrayList<MetricsTreeNode>(this.childrenMap.values());
    }

    public void collapsePackage() {
        while (this.getChildren().size() == 1) {
            MetricsTreeNode singleChild = this.getChildrenMap().values().iterator().next();
            if (this.name.isEmpty()) {
                this.setName(singleChild.getName());
            } else {
                this.setName(this.name + "." + singleChild.getName());
            }
            this.childrenMap = singleChild.getChildrenMap();
        }
    }

    public void insertNode(MetricsTreeNode node) {
        ArrayDeque<String> packageLevels = new ArrayDeque<String>(Arrays.asList(node.getName().split("\\.")));
        this.insertNode(node, packageLevels);
    }

    private void insertNode(MetricsTreeNode node, Deque<String> levels) {
        String nextLevelName = levels.pop();
        this.addValue(node.getValue());
        if (levels.isEmpty()) {
            node.setName(nextLevelName);
            this.childrenMap.put(nextLevelName, node);
        } else {
            this.childrenMap.putIfAbsent(nextLevelName, new MetricsTreeNode(nextLevelName));
            this.childrenMap.get(nextLevelName).insertNode(node, levels);
        }
    }

    public String toString() {
        return "MetricsTreeNode '%s' (%s)".formatted(this.name, this.value);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.childrenMap, this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof MetricsTreeNode) {
            MetricsTreeNode other = (MetricsTreeNode)o;
            return Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value) && Objects.equals(this.childrenMap, other.childrenMap);
        }
        return false;
    }
}

