/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.metrics.model;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.hm.hafner.util.Generated;
import io.jenkins.plugins.metrics.model.Metric;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract class MetricsMeasurement
implements Serializable {
    private static final long serialVersionUID = 7472039462715167623L;
    private final HashMap<String, Metric> metrics;
    private final String fileName;
    private final String packageName;
    private final String className;

    protected MetricsMeasurement(Map<String, Metric> metrics, String fileName, String packageName, String className) {
        this.metrics = new HashMap<String, Metric>(metrics);
        this.fileName = fileName;
        this.packageName = packageName;
        this.className = className;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getQualifiedClassName() {
        return this.getPackageName() + "." + this.getClassName();
    }

    public Map<String, Metric> getMetrics() {
        return Map.copyOf(this.metrics);
    }

    protected void merge(Metric metric) {
        if (this.metrics.containsKey(metric.getId())) {
            throw new IllegalArgumentException("Metric with id '%s' is already present".formatted(metric.getId()));
        }
        this.metrics.put(metric.getId(), metric);
    }

    public Optional<Number> getMetric(String id) {
        return Optional.ofNullable(this.getMetrics().get(id)).map(Metric::rawValue);
    }

    public abstract MetricsMeasurement merge(MetricsMeasurement var1);

    @Generated
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricsMeasurement that = (MetricsMeasurement)o;
        return Objects.equals(this.metrics, that.metrics) && Objects.equals(this.fileName, that.fileName) && Objects.equals(this.packageName, that.packageName) && Objects.equals(this.className, that.className);
    }

    @Generated
    public int hashCode() {
        return Objects.hash(this.metrics, this.fileName, this.packageName, this.className);
    }

    public static abstract class MetricsMeasurementBuilder<T extends MetricsMeasurementBuilder<T>> {
        private final Map<String, Metric> metrics = new HashMap<String, Metric>();
        private String fileName;
        private String packageName;
        private String className;

        public Map<String, Metric> getMetrics() {
            return this.metrics;
        }

        @CanIgnoreReturnValue
        public T withMetric(Metric metric) {
            if (this.metrics.containsKey(metric.getId())) {
                throw new IllegalArgumentException("Metric with id '%s' is already present".formatted(metric.getId()));
            }
            this.metrics.put(metric.getId(), metric);
            return (T)this;
        }

        public String getFileName() {
            return this.fileName;
        }

        @CanIgnoreReturnValue
        public T withFileName(String fileName) {
            this.fileName = fileName;
            return (T)this;
        }

        public String getPackageName() {
            return this.packageName;
        }

        @CanIgnoreReturnValue
        public T withPackageName(String packageName) {
            this.packageName = packageName;
            return (T)this;
        }

        public String getClassName() {
            return this.className;
        }

        @CanIgnoreReturnValue
        public T withClassName(String className) {
            this.className = className;
            return (T)this;
        }

        public abstract MetricsMeasurement build();
    }
}

