/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.metrics.model;

import edu.hm.hafner.util.Generated;
import io.jenkins.plugins.metrics.model.Metric;
import io.jenkins.plugins.metrics.model.MetricDefinition;
import java.util.Objects;

public final class IntegerMetric
extends Metric {
    private static final long serialVersionUID = 179851851088742850L;
    private final int value;

    public IntegerMetric(MetricDefinition metricDefinition, int value) {
        super(metricDefinition);
        this.value = value;
    }

    @Override
    public boolean needsRounding() {
        return true;
    }

    @Override
    public String renderValue() {
        return String.valueOf(this.value);
    }

    @Override
    public Integer rawValue() {
        return this.value;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IntegerMetric that = (IntegerMetric)o;
        return this.value == that.value;
    }

    @Override
    @Generated
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }
}

