/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.metrics.model;

import edu.hm.hafner.util.Generated;
import io.jenkins.plugins.metrics.model.Metric;
import io.jenkins.plugins.metrics.model.MetricDefinition;
import java.util.Locale;
import java.util.Objects;

public final class DoubleMetric
extends Metric {
    private static final long serialVersionUID = -7838111350390919589L;
    private final double value;

    public DoubleMetric(MetricDefinition metricDefinition, double value) {
        super(metricDefinition);
        this.value = value;
    }

    @Override
    public String renderValue() {
        return String.format(Locale.ENGLISH, "%.2f", this.value);
    }

    @Override
    public Double rawValue() {
        return this.value;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DoubleMetric that = (DoubleMetric)o;
        return Double.compare(this.value, that.value) == 0;
    }

    @Override
    @Generated
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }
}

