/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.metrics.view;

import hudson.model.ModelObject;
import hudson.model.Run;
import io.jenkins.plugins.datatables.DefaultAsyncTableContentProvider;
import io.jenkins.plugins.datatables.TableModel;
import io.jenkins.plugins.metrics.extension.MetricsProvider;
import io.jenkins.plugins.metrics.extension.MetricsProviderFactory;
import io.jenkins.plugins.metrics.model.ClassMetricsMeasurement;
import io.jenkins.plugins.metrics.model.Metric;
import io.jenkins.plugins.metrics.model.MetricDefinition;
import io.jenkins.plugins.metrics.model.MetricsMeasurement;
import io.jenkins.plugins.metrics.view.ClassDetailsView;
import io.jenkins.plugins.metrics.view.JacksonFacade;
import io.jenkins.plugins.metrics.view.Messages;
import io.jenkins.plugins.metrics.view.MetricsTableModel;
import io.jenkins.plugins.metrics.view.MetricsTreeNode;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class MetricsView
extends DefaultAsyncTableContentProvider
implements ModelObject {
    private final Run<?, ?> owner;
    private final List<ClassMetricsMeasurement> metricsMeasurements;
    private final List<MetricDefinition> supportedMetrics;
    private final List<String> projectOverview;

    public MetricsView(Run<?, ?> build) {
        this.owner = build;
        this.metricsMeasurements = MetricsProviderFactory.findAllFor(build).stream().map(MetricsProvider::getMetricsMeasurements).flatMap(Collection::stream).filter(ClassMetricsMeasurement.class::isInstance).collect(Collectors.groupingBy(MetricsMeasurement::getQualifiedClassName)).values().stream().map(measurementsPerFile -> measurementsPerFile.stream().reduce(MetricsMeasurement::merge).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
        this.supportedMetrics = MetricsProviderFactory.findAllAvailableMetricsFor(build).stream().filter(metricDefinition -> metricDefinition.isValidForScope(MetricDefinition.Scope.CLASS)).collect(Collectors.toList());
        this.projectOverview = MetricsProviderFactory.findAllFor(build).stream().map(MetricsProvider::getProjectSummaryEntries).reduce(new LinkedList(), (acc, summary) -> {
            acc.addAll(summary);
            return acc;
        });
    }

    public String getDisplayName() {
        return Messages.metrics();
    }

    public final Run<?, ?> getOwner() {
        return this.owner;
    }

    @JavaScriptMethod
    public List<MetricDefinition> getSupportedMetrics() {
        return this.supportedMetrics;
    }

    public String getSupportedMetricsJSON() {
        return this.toJson(this.supportedMetrics);
    }

    public List<String> getProjectOverview() {
        return this.projectOverview;
    }

    @JavaScriptMethod
    public String getMetricsJSON() {
        return this.toJson((Object)new MetricsTableModel("metrics-table", this.supportedMetrics, this.metricsMeasurements));
    }

    @JavaScriptMethod
    public String getMetricsTree(String metricId) {
        List<MetricsTreeNode> nodes = this.metricsMeasurements.stream().map(measurement -> {
            double value = measurement.getMetric(metricId).orElse(0.0).doubleValue();
            if (!Double.isFinite(value)) {
                value = 0.0;
            }
            return new MetricsTreeNode(measurement.getQualifiedClassName(), value);
        }).collect(Collectors.toList());
        MetricsTreeNode root = new MetricsTreeNode("");
        nodes.forEach(root::insertNode);
        root.collapsePackage();
        return this.toJson(root);
    }

    private List<Double> getAllMetrics(String metricId) {
        return this.metricsMeasurements.stream().map(m -> m.getMetric(metricId).orElse(Double.NaN)).map(Number::doubleValue).filter(Double::isFinite).collect(Collectors.toList());
    }

    private boolean needsRounding(String metricId) {
        return this.metricsMeasurements.stream().map(m -> m.getMetrics().get(metricId)).findFirst().map(Metric::needsRounding).orElse(false);
    }

    @JavaScriptMethod
    public String getHistogram(String metricId) {
        int numBins;
        double binWidth;
        List<Double> values = this.getAllMetrics(metricId);
        if (values.isEmpty()) {
            return "{\"data\": [], \"labels\":[]}";
        }
        DescriptiveStatistics statistics = new DescriptiveStatistics();
        values.forEach(arg_0 -> ((DescriptiveStatistics)statistics).addValue(arg_0));
        double min = statistics.getMin();
        double max = statistics.getMax();
        double iqr = statistics.getPercentile(75.0) - statistics.getPercentile(25.0);
        if (iqr > 0.0) {
            binWidth = 2.0 * iqr / Math.cbrt(values.size());
            numBins = (int)Math.round((max - min) / binWidth);
        } else if (max - min > 0.0) {
            numBins = (int)(1.0 + Math.log(values.size()) / Math.log(2.0));
            binWidth = (max - min) / (double)numBins;
        } else {
            numBins = 1;
            binWidth = 1.0;
        }
        if (this.needsRounding(metricId) && (binWidth = (double)Math.round(binWidth)) < 1.0) {
            binWidth = 1.0;
        }
        int[] histogramData = new int[numBins];
        for (double v : values) {
            int binId = (int)((v - min) / binWidth);
            if (binId < 0) {
                binId = 0;
            } else if (binId >= numBins) {
                binId = numBins - 1;
            }
            int n = binId;
            histogramData[n] = histogramData[n] + 1;
        }
        DecimalFormat labelFormat = new DecimalFormat("#.##");
        String[] binLabels = new String[numBins];
        for (int i = 0; i < numBins; ++i) {
            double left = min + (double)i * binWidth;
            double right = min + (double)(i + 1) * binWidth;
            binLabels[i] = "%s - %s".formatted(labelFormat.format(left), labelFormat.format(right));
        }
        HashMap<String, Object[]> result = new HashMap<String, Object[]>();
        result.put("data", histogramData);
        result.put("labels", binLabels);
        return this.toJson(result);
    }

    @JavaScriptMethod
    public String getScatterPlot(String metricId, String secondMetricId) {
        List data = this.metricsMeasurements.stream().map(m -> new ScatterPlotDataItem(m.getClassName(), m.getMetric(metricId).orElse(Double.NaN), m.getMetric(secondMetricId).orElse(Double.NaN))).collect(Collectors.toList());
        return this.toJson(data);
    }

    private String toJson(Object object) {
        JacksonFacade facade = new JacksonFacade();
        return facade.toJson(object);
    }

    public Object getDynamic(String link, StaplerRequest2 request, StaplerResponse2 response) {
        return new ClassDetailsView(this.owner, link);
    }

    public TableModel getTableModel(String id) {
        return new MetricsTableModel(id, this.supportedMetrics, this.metricsMeasurements);
    }

    private static final class ScatterPlotDataItem {
        private final String name;
        private final List<Number> value;

        private ScatterPlotDataItem(String name, Number ... values) {
            this.name = name;
            this.value = Arrays.asList(values);
        }

        public String getName() {
            return this.name;
        }

        public List<Number> getValue() {
            return this.value;
        }
    }
}

