/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.metrics.view;

import hudson.model.ModelObject;
import hudson.model.Run;
import io.jenkins.plugins.datatables.DefaultAsyncTableContentProvider;
import io.jenkins.plugins.datatables.TableModel;
import io.jenkins.plugins.metrics.extension.MetricsProvider;
import io.jenkins.plugins.metrics.extension.MetricsProviderFactory;
import io.jenkins.plugins.metrics.model.ClassMetricsMeasurement;
import io.jenkins.plugins.metrics.model.MethodMetricsMeasurement;
import io.jenkins.plugins.metrics.model.Metric;
import io.jenkins.plugins.metrics.model.MetricDefinition;
import io.jenkins.plugins.metrics.model.MetricsMeasurement;
import io.jenkins.plugins.metrics.view.ClassDetailsTableModel;
import io.jenkins.plugins.metrics.view.JacksonFacade;
import io.jenkins.plugins.metrics.view.Messages;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class ClassDetailsView
extends DefaultAsyncTableContentProvider
implements ModelObject {
    private final Run<?, ?> owner;
    private final List<MethodMetricsMeasurement> methodMetricsMeasurements;
    private final ClassMetricsMeasurement classMetricsMeasurement;
    private final List<MetricDefinition> supportedMetrics;
    private final Map<String, String> classOverview;

    public ClassDetailsView(Run<?, ?> owner, String className) {
        this.owner = owner;
        List<MetricsMeasurement> allMeasurements = MetricsProviderFactory.findAllFor(owner).stream().map(MetricsProvider::getMetricsMeasurements).flatMap(Collection::stream).filter(m -> m.getQualifiedClassName().equals(className)).filter(Objects::nonNull).toList();
        this.methodMetricsMeasurements = allMeasurements.stream().filter(MethodMetricsMeasurement.class::isInstance).map(MethodMetricsMeasurement.class::cast).collect(Collectors.groupingBy(MethodMetricsMeasurement::getMethodName)).values().stream().map(measurementsPerMethod -> measurementsPerMethod.stream().reduce(MethodMetricsMeasurement::merge).orElse(new MethodMetricsMeasurement.MethodMetricsMeasurementBuilder().build())).collect(Collectors.toList());
        this.classMetricsMeasurement = allMeasurements.stream().filter(ClassMetricsMeasurement.class::isInstance).map(ClassMetricsMeasurement.class::cast).reduce(ClassMetricsMeasurement::merge).orElse(new ClassMetricsMeasurement.ClassMetricsMeasurementBuilder().build());
        this.supportedMetrics = MetricsProviderFactory.findAllAvailableMetricsFor(owner).stream().filter(metricDefinition -> metricDefinition.isValidForScope(MetricDefinition.Scope.METHOD)).collect(Collectors.toList());
        this.classOverview = this.classMetricsMeasurement.getMetrics().values().stream().collect(Collectors.toMap(metric -> metric.getMetricDefinition().getDisplayName(), Metric::renderValue));
    }

    public String getDisplayName() {
        return Messages.metrics_for(this.classMetricsMeasurement.getClassName());
    }

    public String getPackageName() {
        return this.classMetricsMeasurement.getPackageName();
    }

    public final Run<?, ?> getOwner() {
        return this.owner;
    }

    @JavaScriptMethod
    public List<MetricDefinition> getSupportedMetrics() {
        return this.supportedMetrics;
    }

    public String getSupportedMetricsJSON() {
        return this.toJson(this.supportedMetrics);
    }

    public Map<String, String> getClassOverview() {
        return this.classOverview;
    }

    @JavaScriptMethod
    public String getMetricsJSON() {
        return this.toJson((Object)new ClassDetailsTableModel(this.supportedMetrics, this.methodMetricsMeasurements));
    }

    private String toJson(Object object) {
        JacksonFacade facade = new JacksonFacade();
        return facade.toJson(object);
    }

    public TableModel getTableModel(String id) {
        return new ClassDetailsTableModel(this.supportedMetrics, this.methodMetricsMeasurements);
    }
}

