/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.metrics.view;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import io.jenkins.plugins.metrics.view.MetricsViewAction;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import jenkins.model.TransientActionFactory;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public class MetricsJobAction
implements Action {
    static final String METRICS_ICON = "symbol-solid/scale-unbalanced plugin-font-awesome-api";
    private final Job<?, ?> owner;

    public MetricsJobAction(Job<?, ?> owner) {
        this.owner = owner;
    }

    public String getDisplayName() {
        return MetricsViewAction.NAME;
    }

    public String getIconFileName() {
        return METRICS_ICON;
    }

    public String getUrlName() {
        return "metrics-aggregation";
    }

    public void doIndex(StaplerRequest2 request, StaplerResponse2 response) throws IOException {
        Run lastCompletedBuild = this.owner.getLastCompletedBuild();
        if (lastCompletedBuild != null) {
            response.sendRedirect2("../%d/%s".formatted(lastCompletedBuild.getNumber(), "metrics-aggregation"));
        }
    }

    @Extension
    public static class JobActionFactory
    extends TransientActionFactory<Job<?, ?>> {
        public Class<Job<?, ?>> type() {
            return Job.class;
        }

        @NonNull
        public Collection<? extends Action> createFor(@NonNull Job<?, ?> target) {
            if (target.getFirstBuild() != null) {
                return Set.of(new MetricsJobAction(target));
            }
            return Collections.emptySet();
        }
    }
}

