/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.metrics.view;

import io.jenkins.plugins.datatables.TableColumn;
import io.jenkins.plugins.datatables.TableConfiguration;
import io.jenkins.plugins.datatables.TableModel;
import io.jenkins.plugins.metrics.model.MethodMetricsMeasurement;
import io.jenkins.plugins.metrics.model.Metric;
import io.jenkins.plugins.metrics.model.MetricDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ClassDetailsTableModel
extends TableModel {
    private final List<MetricDefinition> supportedMetrics;
    private final List<MethodMetricsMeasurement> metricsMeasurements;

    ClassDetailsTableModel(List<MetricDefinition> supportedMetrics, List<MethodMetricsMeasurement> metricsMeasurements) {
        this.supportedMetrics = supportedMetrics;
        this.metricsMeasurements = metricsMeasurements;
    }

    public String getId() {
        return "metrics-table";
    }

    public List<TableColumn> getColumns() {
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        columns.add(new TableColumn("Line", "beginLine"));
        columns.add(new TableColumn("Method", "methodName"));
        columns.addAll(this.supportedMetrics.stream().map(metricDefinition -> new TableColumn(metricDefinition.getDisplayName(), "metricsDisplay." + metricDefinition.getId())).collect(Collectors.toList()));
        return columns;
    }

    public List<Object> getRows() {
        return this.metricsMeasurements.stream().map(Row::new).collect(Collectors.toList());
    }

    public TableConfiguration getTableConfiguration() {
        return new TableConfiguration().responsive().colReorder().stateSave().buttons(new String[]{"colvis"});
    }

    public static class Row {
        private final MethodMetricsMeasurement metricsMeasurement;

        Row(MethodMetricsMeasurement metricsMeasurement) {
            this.metricsMeasurement = metricsMeasurement;
        }

        public String getName() {
            return this.metricsMeasurement.getMethodName();
        }

        public Map<String, String> getMetricsDisplay() {
            return this.metricsMeasurement.getMetrics().values().stream().collect(Collectors.toMap(Metric::getId, Metric::renderValue));
        }

        public Map<String, Number> getMetricsRaw() {
            return this.metricsMeasurement.getMetrics().values().stream().collect(Collectors.toMap(Metric::getId, Metric::rawValue));
        }
    }
}

