/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.metrics.extension;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import hudson.Extension;
import hudson.model.Run;
import io.jenkins.plugins.analysis.core.model.AnalysisResult;
import io.jenkins.plugins.analysis.core.model.ResultAction;
import io.jenkins.plugins.forensics.miner.FileStatistics;
import io.jenkins.plugins.forensics.miner.RepositoryStatistics;
import io.jenkins.plugins.metrics.extension.MetricsProvider;
import io.jenkins.plugins.metrics.extension.MetricsProviderFactory;
import io.jenkins.plugins.metrics.model.ClassMetricsMeasurement;
import io.jenkins.plugins.metrics.model.IntegerMetric;
import io.jenkins.plugins.metrics.model.MetricDefinition;
import io.jenkins.plugins.metrics.model.MetricsMeasurement;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Extension
public class WarningsMetricsProviderFactory
extends MetricsProviderFactory {
    private static final MetricDefinition ERRORS = new MetricDefinition.MetricDefinitionBuilder("ERRORS").withDisplayName("Errors").withDescription("An error, e.g. a compile error.").withReportedBy("warnings-ng-plugin").withPriority(10).withScopes(MetricDefinition.Scope.METHOD, MetricDefinition.Scope.CLASS).build();
    private static final MetricDefinition WARNINGS_HIGH = new MetricDefinition.MetricDefinitionBuilder("WARNING_HIGH").withDisplayName("Warning (high)").withDescription("A warning with priority high.").withReportedBy("warnings-ng-plugin").withPriority(10).withScopes(MetricDefinition.Scope.METHOD, MetricDefinition.Scope.CLASS).build();
    private static final MetricDefinition WARNINGS_NORMAL = new MetricDefinition.MetricDefinitionBuilder("WARNING_NORMAL").withDisplayName("Warning (normal)").withDescription("A warning with priority normal.").withReportedBy("warnings-ng-plugin").withPriority(10).withScopes(MetricDefinition.Scope.METHOD, MetricDefinition.Scope.CLASS).build();
    private static final MetricDefinition WARNINGS_LOW = new MetricDefinition.MetricDefinitionBuilder("WARNING_LOW").withDisplayName("Warning (low)").withDescription("A warning with priority low.").withReportedBy("warnings-ng-plugin").withPriority(10).withScopes(MetricDefinition.Scope.METHOD, MetricDefinition.Scope.CLASS).build();
    private static final MetricDefinition AUTHORS = new MetricDefinition.MetricDefinitionBuilder("AUTHORS").withDisplayName("Authors").withDescription("The number of unique authors for this file.").withReportedBy("forensics-api-plugin").withPriority(20).withScopes(MetricDefinition.Scope.CLASS).build();
    private static final MetricDefinition COMMITS = new MetricDefinition.MetricDefinitionBuilder("COMMITS").withDisplayName("Commits").withDescription("The number of commits for this file.").withReportedBy("forensics-api-plugin").withPriority(20).withScopes(MetricDefinition.Scope.CLASS).build();

    @Override
    public MetricsProvider getMetricsProviderFor(Run<?, ?> build) {
        MetricsProvider provider = new MetricsProvider();
        provider.setOrigin("warnings-ng-plugin");
        List actions = build.getActions(ResultAction.class);
        RepositoryStatistics stats = actions.stream().map(ResultAction::getResult).map(AnalysisResult::getForensics).reduce(new RepositoryStatistics(), (acc, r) -> {
            acc.addAll(r);
            return acc;
        });
        Report allIssues = actions.stream().map(ResultAction::getResult).map(AnalysisResult::getIssues).reduce(new Report(), (rec$, xva$0) -> ((Report)rec$).addAll(new Report[]{xva$0}));
        provider.addProjectSummaryEntry("%d Errors".formatted(allIssues.getSizeOf(Severity.ERROR)));
        provider.addProjectSummaryEntry("%d Warnings (%d high, %d normal, %d low)".formatted(allIssues.getSizeOf(Severity.WARNING_HIGH) + allIssues.getSizeOf(Severity.WARNING_NORMAL) + allIssues.getSizeOf(Severity.WARNING_LOW), allIssues.getSizeOf(Severity.WARNING_HIGH), allIssues.getSizeOf(Severity.WARNING_NORMAL), allIssues.getSizeOf(Severity.WARNING_LOW)));
        List<MetricsMeasurement> metricsMeasurements = allIssues.groupByProperty("fileName").entrySet().stream().map(entry -> this.createMetric((Map.Entry<String, Report>)entry, stats)).collect(Collectors.toList());
        provider.setMetricsMeasurements(metricsMeasurements);
        return provider;
    }

    private ClassMetricsMeasurement createMetric(Map.Entry<String, Report> entry, RepositoryStatistics stats) {
        ClassMetricsMeasurement.ClassMetricsMeasurementBuilder measurement = new ClassMetricsMeasurement.ClassMetricsMeasurementBuilder();
        measurement.withFileName(entry.getKey());
        Report report = entry.getValue();
        Issue first = report.get(0);
        measurement.withPackageName(first.getPackageName());
        measurement.withClassName(first.getBaseName().replace(".java", ""));
        measurement.withMetric(new IntegerMetric(ERRORS, report.getSizeOf(Severity.ERROR)));
        measurement.withMetric(new IntegerMetric(WARNINGS_HIGH, report.getSizeOf(Severity.WARNING_HIGH)));
        measurement.withMetric(new IntegerMetric(WARNINGS_NORMAL, report.getSizeOf(Severity.WARNING_NORMAL)));
        measurement.withMetric(new IntegerMetric(WARNINGS_LOW, report.getSizeOf(Severity.WARNING_LOW)));
        if (stats.contains(entry.getKey())) {
            FileStatistics fileStatistics = stats.get(entry.getKey());
            measurement.withMetric(new IntegerMetric(AUTHORS, fileStatistics.getNumberOfAuthors()));
            measurement.withMetric(new IntegerMetric(COMMITS, fileStatistics.getNumberOfCommits()));
        }
        return measurement.build();
    }

    @Override
    public Set<MetricDefinition> getAvailableMetricsFor(Run<?, ?> build) {
        List actions = build.getActions(ResultAction.class);
        if (actions.isEmpty()) {
            return Set.of();
        }
        return Set.of(ERRORS, WARNINGS_HIGH, WARNINGS_NORMAL, WARNINGS_LOW, AUTHORS, COMMITS);
    }
}

