// CHECKSTYLE:OFF

package io.jenkins.plugins.metrics.view;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code metrics.for}: {@code Metrics for class {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Metrics for class {0}}
     */
    public static String metrics_for(Object arg0) {
        return holder.format("metrics.for", arg0);
    }

    /**
     * Key {@code metrics.for}: {@code Metrics for class {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Metrics for class {0}}
     */
    public static Localizable _metrics_for(Object arg0) {
        return new Localizable(holder, "metrics.for", arg0);
    }

    /**
     * Key {@code metrics}: {@code Metrics}.
     * 
     * @return
     *     {@code Metrics}
     */
    public static String metrics() {
        return holder.format("metrics");
    }

    /**
     * Key {@code metrics}: {@code Metrics}.
     * 
     * @return
     *     {@code Metrics}
     */
    public static Localizable _metrics() {
        return new Localizable(holder, "metrics");
    }

}
