/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mcp.server.extensions;

import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.AdministrativeMonitor;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.User;
import hudson.model.queue.ScheduleResult;
import hudson.security.Permission;
import hudson.slaves.Cloud;
import io.jenkins.plugins.mcp.server.McpServerExtension;
import io.jenkins.plugins.mcp.server.annotation.Tool;
import io.jenkins.plugins.mcp.server.annotation.ToolParam;
import io.jenkins.plugins.mcp.server.extensions.util.JenkinsUtil;
import io.jenkins.plugins.mcp.server.extensions.util.ParameterValueFactory;
import io.jenkins.plugins.mcp.server.tool.JenkinsMcpContext;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.model.queue.QueueItem;
import lombok.Generated;
import org.jenkinsci.plugins.workflow.cps.replay.ReplayAction;
import org.kohsuke.stapler.export.Exported;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class DefaultMcpServer
implements McpServerExtension {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultMcpServer.class);
    public static final String FULL_NAME = "fullName";

    @Tool(description="Get a specific build or the last build of a Jenkins job", annotations=@Tool.Annotations(destructiveHint=false))
    public Run getBuild(@ToolParam(description="Job full name of the Jenkins job (e.g., 'folder/job-name')") String jobFullName, @Nullable @ToolParam(description="Build number (optional, if not provided, returns the last build)", required=false) Integer buildNumber) {
        return JenkinsUtil.getBuildByNumberOrLast(jobFullName, buildNumber).orElse(null);
    }

    @Tool(description="Get a Jenkins job by its full path", annotations=@Tool.Annotations(destructiveHint=false))
    public Job getJob(@ToolParam(description="Job full name of the Jenkins job (e.g., 'folder/job-name')") String jobFullName) {
        return (Job)Jenkins.get().getItemByFullName(jobFullName, Job.class);
    }

    @Tool(description="Trigger a build for a Jenkins job", treePruneSupported=true)
    public QueueItem triggerBuild(@ToolParam(description="Full path of the Jenkins job (e.g., 'folder/job-name')") String jobFullName, @ToolParam(description="Build parameters (optional, e.g., {key1=value1,key2=value2})", required=false) Map<String, Object> parameters) {
        ParameterizedJobMixIn.ParameterizedJob job = (ParameterizedJobMixIn.ParameterizedJob)Jenkins.get().getItemByFullName(jobFullName, ParameterizedJobMixIn.ParameterizedJob.class);
        if (job != null) {
            job.checkPermission(Item.BUILD);
            String remoteAddr = JenkinsMcpContext.get().getHttpServletRequest().getRemoteAddr();
            CauseAction action = new CauseAction(new Cause[]{new MCPCause(remoteAddr), new Cause.UserIdCause()});
            ArrayList<Object> actions = new ArrayList<Object>();
            actions.add(action);
            if (job.isParameterized() && job instanceof Job) {
                Job j = (Job)job;
                ParametersDefinitionProperty parametersDefinition = (ParametersDefinitionProperty)j.getProperty(ParametersDefinitionProperty.class);
                List<ParameterValue> parameterValues = parametersDefinition.getParameterDefinitions().stream().map(param -> {
                    if (parameters != null && parameters.containsKey(param.getName())) {
                        Object value = parameters.get(param.getName());
                        return ParameterValueFactory.createParameterValue(param, value);
                    }
                    return param.getDefaultParameterValue();
                }).filter(Objects::nonNull).toList();
                actions.add(new ParametersAction(parameterValues));
            }
            ScheduleResult scheduleResult = Jenkins.get().getQueue().schedule2((Queue.Task)job, 0, actions);
            return scheduleResult.getItem();
        }
        return null;
    }

    @Tool(description="Get a paginated list of Jenkins jobs, sorted by name. Returns up to 'limit' jobs starting from the 'skip' index. If no jobs are available in the requested range, returns an empty list.", annotations=@Tool.Annotations(destructiveHint=false))
    public List<Job> getJobs(@ToolParam(description="The full path of the Jenkins folder (e.g., 'folder'), if not specified, it returns the items under root", required=false) String parentFullName, @ToolParam(description="The 0 based started index, if not specified, then start from the first (0)", required=false) Integer skip, @ToolParam(description="The maximum number of items to return. If not specified, returns 10 items. Cannot exceed 10 items.", required=false) Integer limit) {
        if (skip == null || skip < 0) {
            skip = 0;
        }
        if (limit == null || limit < 0 || limit > 10) {
            limit = 10;
        }
        Jenkins parent = null;
        if (parentFullName == null || parentFullName.isEmpty()) {
            parent = Jenkins.get();
        } else {
            AbstractItem fullNameItem = (AbstractItem)Jenkins.get().getItemByFullName(parentFullName, AbstractItem.class);
            if (fullNameItem instanceof ItemGroup) {
                parent = (ItemGroup)fullNameItem;
            }
        }
        if (parent != null) {
            return parent.getItemsStream().sorted(Comparator.comparing(Item::getName)).skip(skip.intValue()).limit(limit.intValue()).toList();
        }
        return List.of();
    }

    @Tool(description="Update build display name and/or description")
    public boolean updateBuild(@ToolParam(description="Full path of the Jenkins job (e.g., 'folder/job-name')") String jobFullName, @Nullable @ToolParam(description="Build number (optional, if not provided, updates the last build)", required=false) Integer buildNumber, @Nullable @ToolParam(description="New display name for the build", required=false) String displayName, @Nullable @ToolParam(description="New description for the build", required=false) String description) {
        Optional<Run> optBuild = JenkinsUtil.getBuildByNumberOrLast(jobFullName, buildNumber);
        boolean updated = false;
        if (optBuild.isPresent()) {
            Run build = optBuild.get();
            if (displayName != null && !displayName.isEmpty()) {
                build.setDisplayName(displayName);
                updated = true;
            }
            if (description != null && !description.isEmpty()) {
                build.setDescription(description);
                updated = true;
            }
        }
        return updated;
    }

    @Tool(description="Get information about the currently authenticated user, including their full name or 'anonymous' if not authenticated", structuredOutput=true, annotations=@Tool.Annotations(destructiveHint=false))
    public WhoAmIResponse whoAmI() {
        return Optional.ofNullable(User.current()).map(user -> new WhoAmIResponse(user.getFullName())).orElse(new WhoAmIResponse("anonymous"));
    }

    @Tool(description="Checks the health and readiness status of a Jenkins instance, including whether it's in quiet mode, has active administrative monitors, current queue size, root URL Status, and available executor capacity. This tool provides a comprehensive overview of the controller's operational state to determine if it's stable and ready to build. Use this tool to assess Jenkins instance health rather than simple up/down status.", annotations=@Tool.Annotations(destructiveHint=false))
    public Map<String, Object> getStatus() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Jenkins jenkins = Jenkins.get();
        boolean quietMode = jenkins.isQuietingDown();
        Queue queue = jenkins.getQueue();
        Integer availableExecutors = Arrays.stream(jenkins.getComputers()).filter(Computer::isOnline).map(Computer::countExecutors).reduce(0, Integer::sum);
        map.put("Quiet Mode", quietMode);
        if (quietMode) {
            map.put("Quiet Mode reason", jenkins.getQuietDownReason() != null ? jenkins.getQuietDownReason() : "Unknown");
        }
        map.put("Full Queue Size", queue.getItems().length);
        map.put("Buildable Queue Size", queue.countBuildableItems());
        map.put("Available executors (any label)", availableExecutors);
        if (Jenkins.get().hasAnyPermission(new Permission[]{Jenkins.SYSTEM_READ})) {
            map.put("Defined clouds that can provide agents (any label)", jenkins.clouds.stream().filter(cloud -> cloud.canProvision(new Cloud.CloudState(null, 1))).map(Cloud::getDisplayName).toList());
        }
        map.put("Active administrative monitors", jenkins.getActiveAdministrativeMonitors().stream().map(AdministrativeMonitor::getDisplayName).toList());
        if (jenkins.getRootUrl() == null || jenkins.getRootUrl().isEmpty()) {
            map.put("Root URL Status", "ERROR: Jenkins root URL is not configured. Please configure the Jenkins URL under \"Manage Jenkins \u2192 Configure System \u2192 Jenkins Location\" so tools like getJobs can work properly.\n ");
        } else {
            map.put("Root URL Status", "OK");
        }
        return map;
    }

    @Tool(description="Get the queue item details by its ID. The caller can check the queue item's status, build details, and other relevant information.", treePruneSupported=true, annotations=@Tool.Annotations(destructiveHint=false))
    public QueueItem getQueueItem(@ToolParam(description="The queue item id") long id) {
        return Jenkins.get().getQueue().getItem(id);
    }

    @Tool(description="Rebuild a Jenkins build: re-run with the same parameters (and for Pipeline jobs, the same script when possible). Returns the queue item for the new build.", treePruneSupported=true)
    public QueueItem rebuildBuild(@ToolParam(description="Full path of the Jenkins job (e.g., 'folder/job-name')") String jobFullName, @Nullable @ToolParam(description="Build number (optional, if not provided, rebuilds the last build)", required=false) Integer buildNumber) {
        ParameterizedJobMixIn.ParameterizedJob jobParam;
        Optional<Run> optBuild = JenkinsUtil.getBuildByNumberOrLast(jobFullName, buildNumber);
        if (optBuild.isEmpty()) {
            return null;
        }
        Run run = optBuild.get();
        Job job = run.getParent();
        job.checkPermission(Item.BUILD);
        ReplayAction replayAction = (ReplayAction)run.getAction(ReplayAction.class);
        if (replayAction != null && replayAction.isRebuildEnabled()) {
            Queue.Item item = replayAction.run2(replayAction.getOriginalScript(), replayAction.getOriginalLoadedScripts());
            return item != null ? item : null;
        }
        ArrayList<Object> actions = new ArrayList<Object>();
        String remoteAddr = JenkinsMcpContext.get().getHttpServletRequest().getRemoteAddr();
        actions.add(new CauseAction(new Cause[]{new MCPCause(remoteAddr), new Cause.UserIdCause()}));
        ParametersAction paramsAction = (ParametersAction)run.getAction(ParametersAction.class);
        if (paramsAction != null) {
            actions.add(paramsAction);
        }
        if ((jobParam = (ParameterizedJobMixIn.ParameterizedJob)Jenkins.get().getItemByFullName(jobFullName, ParameterizedJobMixIn.ParameterizedJob.class)) == null) {
            return null;
        }
        ScheduleResult scheduleResult = Jenkins.get().getQueue().schedule2((Queue.Task)jobParam, 0, actions);
        return scheduleResult.getItem();
    }

    @Tool(description="Get the pipeline script(s) of a build for replay. Returns the main script and loaded scripts. Only available for Pipeline (replayable) builds.", structuredOutput=true, annotations=@Tool.Annotations(destructiveHint=false))
    public GetReplayScriptsResult getReplayScripts(@ToolParam(description="Full path of the Jenkins job (e.g., 'folder/job-name')") String jobFullName, @Nullable @ToolParam(description="Build number (optional, if not provided, uses the last build)", required=false) Integer buildNumber) {
        Optional<Run> optBuild = JenkinsUtil.getBuildByNumberOrLast(jobFullName, buildNumber);
        if (optBuild.isEmpty()) {
            throw new IllegalArgumentException("Build not found for job " + jobFullName);
        }
        Run run = optBuild.get();
        ReplayAction replayAction = (ReplayAction)run.getAction(ReplayAction.class);
        if (replayAction == null) {
            throw new IllegalArgumentException("Not a replayable Pipeline build. Replay is only available for Pipeline jobs (workflow-cps).");
        }
        String mainScript = replayAction.getOriginalScript();
        Map<String, String> loadedScripts = replayAction.getOriginalLoadedScripts();
        return new GetReplayScriptsResult(mainScript, loadedScripts != null ? loadedScripts : Map.of());
    }

    @Tool(description="Replay a Pipeline build with optionally modified script(s). Runs the job again with the given main script and optional loaded scripts. Only available for Pipeline jobs.", treePruneSupported=true)
    public QueueItem replayBuild(@ToolParam(description="Full path of the Jenkins job (e.g., 'folder/job-name')") String jobFullName, @Nullable @ToolParam(description="Build number (optional, if not provided, uses the last build)", required=false) Integer buildNumber, @ToolParam(description="Main pipeline script content") String mainScript, @Nullable @ToolParam(description="Loaded scripts map (optional): script name to content. If not provided, original loaded scripts are used.", required=false) Map<String, String> loadedScripts) {
        Queue.Item item;
        Map scriptsToUse;
        Optional<Run> optBuild = JenkinsUtil.getBuildByNumberOrLast(jobFullName, buildNumber);
        if (optBuild.isEmpty()) {
            return null;
        }
        Run run = optBuild.get();
        ReplayAction replayAction = (ReplayAction)run.getAction(ReplayAction.class);
        if (replayAction == null) {
            throw new IllegalArgumentException("Not a replayable Pipeline build. Replay is only available for Pipeline jobs (workflow-cps).");
        }
        if (!replayAction.isEnabled() || !replayAction.isReplayableSandboxTest()) {
            throw new IllegalStateException("Replay not allowed for this build (permission or script approval).");
        }
        Map map = scriptsToUse = loadedScripts != null ? loadedScripts : replayAction.getOriginalLoadedScripts();
        if (scriptsToUse == null) {
            scriptsToUse = Map.of();
        }
        return (item = replayAction.run2(mainScript, scriptsToUse)) != null ? item : null;
    }

    public static class MCPCause
    extends Cause {
        private String addr;

        @Exported(visibility=3)
        public String getAddr() {
            return this.addr;
        }

        public String getShortDescription() {
            return "Triggered via MCP Client from " + this.addr;
        }

        @Generated
        public void setAddr(String addr) {
            this.addr = addr;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MCPCause)) {
                return false;
            }
            MCPCause other = (MCPCause)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            String this$addr = this.getAddr();
            String other$addr = other.getAddr();
            return !(this$addr == null ? other$addr != null : !this$addr.equals(other$addr));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MCPCause;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $addr = this.getAddr();
            result = result * 59 + ($addr == null ? 43 : $addr.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DefaultMcpServer.MCPCause(addr=" + this.getAddr() + ")";
        }

        @Generated
        public MCPCause(String addr) {
            this.addr = addr;
        }
    }

    public record WhoAmIResponse(String fullName) {
    }

    public record GetReplayScriptsResult(String mainScript, Map<String, String> loadedScripts) {
    }
}

