/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mcp.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import io.jenkins.plugins.mcp.server.McpConnectionMetrics;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(value={NoExternalUse.class})
@Extension
public class HealthEndpoint
implements UnprotectedRootAction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HealthEndpoint.class);
    public static final String URL_NAME = "mcp-health";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final AtomicBoolean shuttingDown = new AtomicBoolean(false);
    public static final int SHUTDOWN_GRACE_PERIOD_SECONDS = 5;

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public void doIndex(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        HealthEndpoint.handleHealthRequest((HttpServletResponse)rsp);
    }

    public static void handleHealthRequest(HttpServletResponse response) throws IOException {
        response.setContentType("application/json;charset=UTF-8");
        boolean isShuttingDown = shuttingDown.get();
        if (isShuttingDown) {
            response.setStatus(503);
            response.setHeader("Retry-After", String.valueOf(5));
        } else {
            response.setStatus(200);
        }
        ObjectNode responseJson = objectMapper.createObjectNode();
        responseJson.put("mcpServerStatus", isShuttingDown ? "shutting_down" : "ok");
        responseJson.put("activeConnections", McpConnectionMetrics.getActiveSseConnections());
        responseJson.put("shuttingDown", isShuttingDown);
        responseJson.put("timestamp", Instant.now().toString());
        response.getWriter().write(objectMapper.writeValueAsString((Object)responseJson));
        response.getWriter().flush();
    }

    public static void setShuttingDown(boolean shutdown) {
        shuttingDown.set(shutdown);
        if (shutdown) {
            log.info("MCP Server health endpoint marked as shutting down");
        }
    }

    public static boolean isShuttingDown() {
        return shuttingDown.get();
    }
}

