/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mcp.server;

import hudson.Extension;
import hudson.init.Terminator;
import io.jenkins.plugins.mcp.server.HealthEndpoint;
import lombok.Generated;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(value={NoExternalUse.class})
@Extension
public class McpServerShutdownListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(McpServerShutdownListener.class);

    @Terminator
    public void onShutdown() throws InterruptedException {
        log.info("Jenkins shutdown detected, marking MCP server as shutting down");
        HealthEndpoint.setShuttingDown(true);
        int gracePeriodSeconds = 5;
        log.info("Waiting {} seconds for MCP clients to detect shutdown", (Object)gracePeriodSeconds);
        try {
            Thread.sleep((long)gracePeriodSeconds * 1000L);
        }
        catch (InterruptedException e) {
            log.debug("MCP shutdown grace period interrupted");
            Thread.currentThread().interrupt();
            throw e;
        }
        log.info("MCP server shutdown grace period complete");
    }
}

